/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.health;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.health.ExceptionReporter;
import org.apache.hadoop.yarn.server.nodemanager.health.HealthReporter;
import org.apache.hadoop.yarn.server.nodemanager.health.NodeHealthScriptRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeHealthCheckerService
extends CompositeService
implements HealthReporter {
    public static final Logger LOG = LoggerFactory.getLogger(NodeHealthCheckerService.class);
    private static final int MAX_SCRIPTS = 4;
    private List<HealthReporter> reporters = new ArrayList<HealthReporter>();
    private LocalDirsHandlerService dirsHandler;
    private ExceptionReporter exceptionReporter;
    public static final String SEPARATOR = ";";

    public NodeHealthCheckerService(LocalDirsHandlerService dirHandlerService) {
        super(NodeHealthCheckerService.class.getName());
        this.dirsHandler = dirHandlerService;
        this.exceptionReporter = new ExceptionReporter();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.reporters.add(this.exceptionReporter);
        this.addHealthReporter((Service)this.dirsHandler);
        String[] configuredScripts = conf.getTrimmedStrings("yarn.nodemanager.health-checker.scripts", YarnConfiguration.DEFAULT_NM_HEALTH_CHECK_SCRIPTS);
        if (configuredScripts.length > 4) {
            throw new IllegalArgumentException("Due to performance reasons running more than 4scripts is not allowed.");
        }
        for (String configuredScript : configuredScripts) {
            this.addHealthReporter((Service)NodeHealthScriptRunner.newInstance(configuredScript, conf));
        }
        super.serviceInit(conf);
    }

    @VisibleForTesting
    void addHealthReporter(Service service) throws Exception {
        if (service != null) {
            if (this.getServices().stream().noneMatch(x -> x.getName().equals(service.getName()))) {
                if (!(service instanceof HealthReporter)) {
                    throw new Exception("Attempted to add service to NodeHealthCheckerService that does not implement HealthReporter.");
                }
                this.reporters.add((HealthReporter)service);
                this.addService(service);
            } else {
                LOG.debug("Omitting duplicate service: {}.", (Object)service.getName());
            }
        }
    }

    @Override
    public String getHealthReport() {
        ArrayList reports = this.reporters.stream().map(reporter -> Strings.emptyToNull((String)reporter.getHealthReport())).collect(Collectors.toCollection(ArrayList::new));
        return Joiner.on((String)SEPARATOR).skipNulls().join((Iterable)reports);
    }

    @Override
    public boolean isHealthy() {
        return this.reporters.stream().allMatch(HealthReporter::isHealthy);
    }

    @Override
    public long getLastHealthReportTime() {
        Optional<Long> max = this.reporters.stream().map(HealthReporter::getLastHealthReportTime).max(Long::compareTo);
        return max.orElse(0L);
    }

    public LocalDirsHandlerService getDiskHandler() {
        return this.dirsHandler;
    }

    public void reportException(Exception exception) {
        this.exceptionReporter.reportException(exception);
    }
}

