/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.ClientGSIContext;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import org.apache.hadoop.hdfs.server.namenode.ha.IPFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.ObserverReadProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.ReadOnly;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcInvocationHandler;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterObserverReadProxyProvider<T>
extends AbstractNNFailoverProxyProvider<T> {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(ObserverReadProxyProvider.class);
    private final AlignmentContext alignmentContext = new ClientGSIContext();
    private final AbstractNNFailoverProxyProvider<T> innerProxy;
    private final FailoverProxyProvider.ProxyInfo<T> wrapperProxy;
    private final boolean observerReadEnabled;
    private final long autoMsyncPeriodMs;
    private volatile long lastMsyncTimeMs = -1L;

    public RouterObserverReadProxyProvider(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> factory) {
        this(conf, uri, xface, factory, new IPFailoverProxyProvider<T>(conf, uri, xface, factory));
    }

    public RouterObserverReadProxyProvider(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> factory, AbstractNNFailoverProxyProvider<T> failoverProxy) {
        super(conf, uri, xface, factory);
        factory.setAlignmentContext(this.alignmentContext);
        this.innerProxy = failoverProxy;
        String proxyInfoString = "RouterObserverReadProxyProvider for " + this.innerProxy.getProxy();
        Object wrappedProxy = Proxy.newProxyInstance(RouterObserverReadInvocationHandler.class.getClassLoader(), new Class[]{xface}, (InvocationHandler)((Object)new RouterObserverReadInvocationHandler()));
        this.wrapperProxy = new FailoverProxyProvider.ProxyInfo(wrappedProxy, proxyInfoString);
        this.autoMsyncPeriodMs = conf.getTimeDuration("dfs.client.failover.observer.auto-msync-period." + uri.getHost(), -1L, TimeUnit.MILLISECONDS);
        if (wrappedProxy instanceof ClientProtocol) {
            this.observerReadEnabled = true;
        } else {
            LOG.info("Disabling observer reads for {} because the requested proxy class does not implement {}", (Object)uri, (Object)ClientProtocol.class.getName());
            this.observerReadEnabled = false;
        }
    }

    public AlignmentContext getAlignmentContext() {
        return this.alignmentContext;
    }

    public FailoverProxyProvider.ProxyInfo<T> getProxy() {
        return this.wrapperProxy;
    }

    public void performFailover(T currentProxy) {
        this.innerProxy.performFailover(currentProxy);
    }

    @Override
    public boolean useLogicalURI() {
        return this.innerProxy.useLogicalURI();
    }

    public void close() throws IOException {
        this.innerProxy.close();
    }

    private ClientProtocol getProxyAsClientProtocol(T proxy) {
        assert (proxy instanceof ClientProtocol) : "BUG: Attempted to use proxy of class " + proxy.getClass() + " as if it was a ClientProtocol.";
        return (ClientProtocol)proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoMsyncIfNecessary() throws IOException {
        if (this.autoMsyncPeriodMs == 0L) {
            this.getProxyAsClientProtocol(this.innerProxy.getProxy().proxy).msync();
        } else if (this.autoMsyncPeriodMs > 0L && Time.monotonicNow() - this.lastMsyncTimeMs > this.autoMsyncPeriodMs) {
            RouterObserverReadProxyProvider routerObserverReadProxyProvider = this;
            synchronized (routerObserverReadProxyProvider) {
                if (Time.monotonicNow() - this.lastMsyncTimeMs > this.autoMsyncPeriodMs) {
                    this.getProxyAsClientProtocol(this.innerProxy.getProxy().proxy).msync();
                    this.lastMsyncTimeMs = Time.monotonicNow();
                }
            }
        }
    }

    private static boolean isRead(Method method) {
        if (!method.isAnnotationPresent(ReadOnly.class)) {
            return false;
        }
        return !((ReadOnly[])method.getAnnotationsByType(ReadOnly.class))[0].activeOnly();
    }

    private class RouterObserverReadInvocationHandler
    implements RpcInvocationHandler {
        private RouterObserverReadInvocationHandler() {
        }

        public Client.ConnectionId getConnectionId() {
            return RPC.getConnectionIdForProxy((Object)((RouterObserverReadProxyProvider)RouterObserverReadProxyProvider.this).innerProxy.getProxy().proxy);
        }

        public void close() throws IOException {
            RouterObserverReadProxyProvider.this.innerProxy.close();
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (RouterObserverReadProxyProvider.this.observerReadEnabled && RouterObserverReadProxyProvider.isRead(method)) {
                RouterObserverReadProxyProvider.this.autoMsyncIfNecessary();
            }
            try {
                return method.invoke(((RouterObserverReadProxyProvider)RouterObserverReadProxyProvider.this).innerProxy.getProxy().proxy, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }
}

