/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.csi.translator;

import csi.v0.Csi;
import java.util.List;
import org.apache.hadoop.yarn.api.protocolrecords.NodePublishVolumeRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesRequest;
import org.apache.hadoop.yarn.csi.translator.ProtoTranslator;
import org.apache.hadoop.yarn.exceptions.YarnException;

public class NodePublishVolumeRequestProtoTranslator<A, B>
implements ProtoTranslator<NodePublishVolumeRequest, Csi.NodePublishVolumeRequest> {
    @Override
    public Csi.NodePublishVolumeRequest convertTo(NodePublishVolumeRequest messageA) throws YarnException {
        Csi.NodePublishVolumeRequest.Builder builder = Csi.NodePublishVolumeRequest.newBuilder();
        ValidateVolumeCapabilitiesRequest.VolumeCapability cap = messageA.getVolumeCapability();
        Csi.VolumeCapability csiVolumeCap = Csi.VolumeCapability.newBuilder().setAccessMode(Csi.VolumeCapability.AccessMode.newBuilder().setModeValue(cap.getAccessMode().ordinal())).setMount(Csi.VolumeCapability.MountVolume.newBuilder().setFsType("xfs").addAllMountFlags(cap.getMountFlags())).build();
        builder.setVolumeCapability(csiVolumeCap);
        builder.setVolumeId(messageA.getVolumeId());
        builder.setTargetPath(messageA.getTargetPath());
        builder.setReadonly(messageA.getReadOnly());
        builder.putAllNodePublishSecrets(messageA.getSecrets());
        builder.putAllPublishInfo(messageA.getPublishContext());
        builder.setStagingTargetPath(messageA.getStagingPath());
        return builder.build();
    }

    @Override
    public NodePublishVolumeRequest convertFrom(Csi.NodePublishVolumeRequest messageB) throws YarnException {
        Csi.VolumeCapability cap0 = messageB.getVolumeCapability();
        ValidateVolumeCapabilitiesRequest.VolumeCapability cap = new ValidateVolumeCapabilitiesRequest.VolumeCapability(ValidateVolumeCapabilitiesRequest.AccessMode.valueOf((String)cap0.getAccessMode().getMode().name()), ValidateVolumeCapabilitiesRequest.VolumeType.FILE_SYSTEM, (List)cap0.getMount().getMountFlagsList());
        return NodePublishVolumeRequest.newInstance((String)messageB.getVolumeId(), (boolean)messageB.getReadonly(), (String)messageB.getTargetPath(), (String)messageB.getStagingTargetPath(), (ValidateVolumeCapabilitiesRequest.VolumeCapability)cap, messageB.getPublishInfoMap(), messageB.getNodePublishSecretsMap());
    }
}

