/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.router.PeriodicService;
import org.apache.hadoop.hdfs.server.federation.router.RBFConfigKeys;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateStoreConnectionMonitorService
extends PeriodicService {
    private static final Logger LOG = LoggerFactory.getLogger(StateStoreConnectionMonitorService.class);
    private final StateStoreService stateStore;

    public StateStoreConnectionMonitorService(StateStoreService store) {
        super(StateStoreConnectionMonitorService.class.getSimpleName());
        this.stateStore = store;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.setIntervalMs(conf.getLong("dfs.federation.router.store.connection.test", RBFConfigKeys.FEDERATION_STORE_CONNECTION_TEST_MS_DEFAULT));
        super.serviceInit(conf);
    }

    @Override
    public void periodicInvoke() {
        LOG.debug("Checking state store connection");
        if (!this.stateStore.isDriverReady()) {
            LOG.info("Attempting to open state store driver.");
            this.stateStore.loadDriver();
        }
    }
}

