/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.com.google.inject.Guice;
import org.apache.hadoop.shaded.com.google.inject.Key;
import org.apache.hadoop.shaded.com.google.inject.MembersInjector;
import org.apache.hadoop.shaded.com.google.inject.Provides;
import org.apache.hadoop.shaded.com.google.inject.ProvisionException;
import org.apache.hadoop.shaded.com.google.inject.TypeLiteral;
import org.apache.hadoop.shaded.com.google.inject.internal.Errors;
import org.apache.hadoop.shaded.com.google.inject.internal.InternalFlags;
import org.apache.hadoop.shaded.com.google.inject.internal.Messages;
import org.apache.hadoop.shaded.com.google.inject.internal.util.SourceProvider;
import org.apache.hadoop.shaded.com.google.inject.internal.util.StackTraceElements;
import org.apache.hadoop.shaded.com.google.inject.spi.Dependency;
import org.apache.hadoop.shaded.com.google.inject.spi.InjectionListener;
import org.apache.hadoop.shaded.com.google.inject.spi.Message;
import org.apache.hadoop.shaded.javax.inject.Provider;

public final class InternalProvisionException
extends Exception {
    private static final Logger logger = Logger.getLogger(Guice.class.getName());
    private static final Set<Dependency<?>> warnedDependencies = Collections.newSetFromMap(new ConcurrentHashMap());
    private final List<Object> sourcesToPrepend = new ArrayList<Object>();
    private final ImmutableList<Message> errors;

    public static InternalProvisionException circularDependenciesDisabled(Class<?> expectedType) {
        return InternalProvisionException.create("Found a circular dependency involving %s, and circular dependencies are disabled.", expectedType);
    }

    public static InternalProvisionException cannotProxyClass(Class<?> expectedType) {
        return InternalProvisionException.create("Tried proxying %s to support a circular dependency, but it is not an interface.", expectedType);
    }

    public static InternalProvisionException create(String format, Object ... arguments) {
        return new InternalProvisionException(Messages.create(format, arguments));
    }

    public static InternalProvisionException errorInUserCode(Throwable cause, String messageFormat, Object ... arguments) {
        Collection<Message> messages = Errors.getMessagesFromThrowable(cause);
        if (!messages.isEmpty()) {
            return new InternalProvisionException(messages);
        }
        return new InternalProvisionException(Messages.create(cause, messageFormat, arguments));
    }

    public static InternalProvisionException subtypeNotProvided(Class<? extends Provider<?>> providerType, Class<?> type) {
        return InternalProvisionException.create("%s doesn't provide instances of %s.", providerType, type);
    }

    public static InternalProvisionException errorInProvider(Throwable cause) {
        return InternalProvisionException.errorInUserCode(cause, "Error in custom provider, %s", cause);
    }

    public static InternalProvisionException errorInjectingMethod(Throwable cause) {
        return InternalProvisionException.errorInUserCode(cause, "Error injecting method, %s", cause);
    }

    public static InternalProvisionException errorInjectingConstructor(Throwable cause) {
        return InternalProvisionException.errorInUserCode(cause, "Error injecting constructor, %s", cause);
    }

    public static InternalProvisionException errorInUserInjector(MembersInjector<?> listener, TypeLiteral<?> type, RuntimeException cause) {
        return InternalProvisionException.errorInUserCode(cause, "Error injecting %s using %s.%n Reason: %s", type, listener, cause);
    }

    public static InternalProvisionException jitDisabled(Key<?> key) {
        return InternalProvisionException.create("Explicit bindings are required and %s is not explicitly bound.", key);
    }

    public static InternalProvisionException errorNotifyingInjectionListener(InjectionListener<?> listener, TypeLiteral<?> type, RuntimeException cause) {
        return InternalProvisionException.errorInUserCode(cause, "Error notifying InjectionListener %s of %s.%n Reason: %s", listener, type, cause);
    }

    static void onNullInjectedIntoNonNullableDependency(Object source, Dependency<?> dependency) throws InternalProvisionException {
        Method annotated;
        if (dependency.getInjectionPoint().getMember() instanceof Method && (annotated = (Method)dependency.getInjectionPoint().getMember()).isAnnotationPresent(Provides.class)) {
            switch (InternalFlags.getNullableProvidesOption()) {
                case ERROR: {
                    break;
                }
                case IGNORE: {
                    return;
                }
                case WARN: {
                    if (warnedDependencies.add(dependency)) {
                        logger.log(Level.WARNING, "Guice injected null into {0} (a {1}), please mark it @Nullable. Use -Dguice_check_nullable_provides_params=ERROR to turn this into an error.", new Object[]{Messages.formatParameter(dependency), Messages.convert(dependency.getKey())});
                    }
                    return;
                }
            }
        }
        String formattedDependency = dependency.getParameterIndex() != -1 ? Messages.formatParameter(dependency) : StackTraceElements.forMember(dependency.getInjectionPoint().getMember());
        throw InternalProvisionException.create("null returned by binding at %s%n but %s is not @Nullable", source, formattedDependency).addSource(source);
    }

    private InternalProvisionException(Message error) {
        this((Iterable<Message>)ImmutableList.of((Object)error));
    }

    private InternalProvisionException(Iterable<Message> errors) {
        this.errors = ImmutableList.copyOf(errors);
        Preconditions.checkArgument((!this.errors.isEmpty() ? 1 : 0) != 0, (Object)"Can't create a provision exception with no errors");
    }

    InternalProvisionException addSource(Object source) {
        if (source == SourceProvider.UNKNOWN_SOURCE) {
            return this;
        }
        int sz = this.sourcesToPrepend.size();
        if (sz > 0 && this.sourcesToPrepend.get(sz - 1) == source) {
            return this;
        }
        this.sourcesToPrepend.add(source);
        return this;
    }

    ImmutableList<Message> getErrors() {
        ImmutableList.Builder builder = ImmutableList.builder();
        List newSources = Lists.reverse(this.sourcesToPrepend);
        for (Message error : this.errors) {
            builder.add((Object)Messages.mergeSources(newSources, error));
        }
        return builder.build();
    }

    public ProvisionException toProvisionException() {
        return new ProvisionException((Iterable<Message>)this.getErrors());
    }
}

