/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.random.AbstractDiscrete;
import org.ojalgo.random.RandomUtils;

public class Poisson
extends AbstractDiscrete {
    private static final long serialVersionUID = -5382163736545207782L;
    private final double myLambda;

    public Poisson() {
        this(PrimitiveMath.ONE);
    }

    public Poisson(double aLambda) {
        this.myLambda = aLambda;
    }

    @Override
    public double getExpected() {
        return this.myLambda;
    }

    @Override
    public double getProbability(int value) {
        return PrimitiveFunction.EXP.invoke(-this.myLambda) * PrimitiveFunction.POW.invoke(this.myLambda, value) / RandomUtils.factorial(value);
    }

    @Override
    public double getVariance() {
        return this.myLambda;
    }

    @Override
    protected double generate() {
        int retVal = -1;
        for (double tmpVal = PrimitiveMath.ZERO; tmpVal <= PrimitiveMath.ONE; tmpVal -= PrimitiveFunction.LOG.invoke(this.random().nextDouble()) / this.myLambda) {
            ++retVal;
        }
        return retVal;
    }
}

