/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer.blockgenerator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public class BlockInfo
implements Writable {
    private LongWritable blockId;
    private LongWritable blockGenerationStamp;
    private LongWritable size;
    private transient short replication;

    LongWritable getBlockId() {
        return this.blockId;
    }

    LongWritable getBlockGenerationStamp() {
        return this.blockGenerationStamp;
    }

    LongWritable getSize() {
        return this.size;
    }

    short getReplication() {
        return this.replication;
    }

    private BlockInfo() {
        this.blockId = new LongWritable();
        this.blockGenerationStamp = new LongWritable();
        this.size = new LongWritable();
    }

    BlockInfo(long blockid, long blockgenerationstamp, long size, short replication) {
        this.blockId = new LongWritable(blockid);
        this.blockGenerationStamp = new LongWritable(blockgenerationstamp);
        this.size = new LongWritable(size);
        this.replication = replication;
    }

    public void write(DataOutput dataOutput) throws IOException {
        this.blockId.write(dataOutput);
        this.blockGenerationStamp.write(dataOutput);
        this.size.write(dataOutput);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.blockId.readFields(dataInput);
        this.blockGenerationStamp.readFields(dataInput);
        this.size.readFields(dataInput);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlockInfo)) {
            return false;
        }
        BlockInfo blkInfo = (BlockInfo)o;
        return blkInfo.getBlockId().equals((Object)this.getBlockId()) && blkInfo.getBlockGenerationStamp().equals((Object)this.getBlockGenerationStamp()) && blkInfo.getSize().equals((Object)this.getSize());
    }

    public int hashCode() {
        return this.blockId.hashCode() + 357 * this.blockGenerationStamp.hashCode() + 9357 * this.size.hashCode();
    }
}

