/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.commit;

import java.io.IOException;
import java.time.Duration;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.commit.ResilientCommitByRename;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestStoreOperations;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestStoreOperationsThroughFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"mapreduce"})
@InterfaceStability.Unstable
public class AbfsManifestStoreOperations
extends ManifestStoreOperationsThroughFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsManifestStoreOperations.class);
    public static final String NAME = AbfsManifestStoreOperations.class.getName();
    private ResilientCommitByRename resilientCommitByRename;

    public AzureBlobFileSystem getFileSystem() {
        return (AzureBlobFileSystem)super.getFileSystem();
    }

    public void bindToFileSystem(FileSystem filesystem, Path path) throws IOException {
        if (!(filesystem instanceof AzureBlobFileSystem)) {
            throw new PathIOException(path.toString(), "Not an abfs filesystem: " + filesystem.getClass());
        }
        super.bindToFileSystem(filesystem, path);
        try {
            this.resilientCommitByRename = this.getFileSystem().createResilientCommitSupport(path);
            LOG.debug("Bonded to filesystem with resilient commits under path {}", (Object)path);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("No resilient commit support under path {}", (Object)path);
        }
    }

    public boolean storePreservesEtagsThroughRenames(Path path) {
        return true;
    }

    public boolean storeSupportsResilientCommit() {
        return this.resilientCommitByRename != null;
    }

    public ManifestStoreOperations.CommitFileResult commitFile(FileEntry entry) throws IOException {
        if (this.resilientCommitByRename != null) {
            Pair<Boolean, Duration> result = this.resilientCommitByRename.commitSingleFileByRename(entry.getSourcePath(), entry.getDestPath(), entry.getEtag());
            return ManifestStoreOperations.CommitFileResult.fromResilientCommit((boolean)((Boolean)result.getLeft()), (Duration)((Duration)result.getRight()));
        }
        return super.commitFile(entry);
    }
}

