/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.PartitionResourcesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResourcesInfo {
    List<PartitionResourcesInfo> resourceUsagesByPartition = new ArrayList<PartitionResourcesInfo>();

    public ResourcesInfo() {
    }

    public ResourcesInfo(ResourceUsage resourceUsage, boolean considerAMUsage) {
        if (resourceUsage == null) {
            return;
        }
        for (String partitionName : resourceUsage.getNodePartitionsSet()) {
            this.resourceUsagesByPartition.add(new PartitionResourcesInfo(partitionName, new ResourceInfo(resourceUsage.getUsed(partitionName)), new ResourceInfo(resourceUsage.getReserved(partitionName)), new ResourceInfo(resourceUsage.getPending(partitionName)), considerAMUsage ? new ResourceInfo(resourceUsage.getAMUsed(partitionName)) : null, considerAMUsage ? new ResourceInfo(resourceUsage.getAMLimit(partitionName)) : null, considerAMUsage ? new ResourceInfo(resourceUsage.getUserAMLimit(partitionName)) : null));
        }
    }

    public ResourcesInfo(ResourceUsage resourceUsage) {
        this(resourceUsage, true);
    }

    public List<PartitionResourcesInfo> getPartitionResourceUsages() {
        return this.resourceUsagesByPartition;
    }

    public void setPartitionResourceUsages(List<PartitionResourcesInfo> resources) {
        this.resourceUsagesByPartition = resources;
    }

    public PartitionResourcesInfo getPartitionResourceUsageInfo(String partitionName) {
        for (PartitionResourcesInfo partitionResourceUsageInfo : this.resourceUsagesByPartition) {
            if (!partitionResourceUsageInfo.getPartitionName().equals(partitionName)) continue;
            return partitionResourceUsageInfo;
        }
        return new PartitionResourcesInfo();
    }
}

