/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecretOperations;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.fs.s3a.impl.HeaderProcessing;
import org.apache.hadoop.fs.s3a.impl.PutObjectOptions;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestFactoryImpl
implements RequestFactory {
    public static final Logger LOG = LoggerFactory.getLogger(RequestFactoryImpl.class);
    private final String bucket;
    private EncryptionSecrets encryptionSecrets;
    private final CannedAccessControlList cannedACL;
    private final long multipartPartCountLimit;
    private final PrepareRequest requestPreparer;
    private final String contentEncoding;
    private final StorageClass storageClass;

    protected RequestFactoryImpl(RequestFactoryBuilder builder) {
        this.bucket = builder.bucket;
        this.cannedACL = builder.cannedACL;
        this.encryptionSecrets = builder.encryptionSecrets;
        this.multipartPartCountLimit = builder.multipartPartCountLimit;
        this.requestPreparer = builder.requestPreparer;
        this.contentEncoding = builder.contentEncoding;
        this.storageClass = builder.storageClass;
    }

    private <T extends AmazonWebServiceRequest> T prepareRequest(T t) {
        return this.requestPreparer != null ? this.requestPreparer.prepareRequest(t) : t;
    }

    @Override
    public CannedAccessControlList getCannedACL() {
        return this.cannedACL;
    }

    protected String getBucket() {
        return this.bucket;
    }

    @Override
    public Optional<SSEAwsKeyManagementParams> generateSSEAwsKeyParams() {
        return EncryptionSecretOperations.createSSEAwsKeyManagementParams(this.encryptionSecrets);
    }

    @Override
    public Optional<SSECustomerKey> generateSSECustomerKey() {
        return EncryptionSecretOperations.createSSECustomerKey(this.encryptionSecrets);
    }

    @Override
    public S3AEncryptionMethods getServerSideEncryptionAlgorithm() {
        return this.encryptionSecrets.getEncryptionMethod();
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    protected void setOptionalUploadPartRequestParameters(UploadPartRequest request) {
        this.generateSSECustomerKey().ifPresent(arg_0 -> ((UploadPartRequest)request).setSSECustomerKey(arg_0));
    }

    protected void setOptionalGetObjectMetadataParameters(GetObjectMetadataRequest request) {
        this.generateSSECustomerKey().ifPresent(arg_0 -> ((GetObjectMetadataRequest)request).setSSECustomerKey(arg_0));
    }

    protected void setOptionalMultipartUploadRequestParameters(InitiateMultipartUploadRequest request) {
        this.generateSSEAwsKeyParams().ifPresent(arg_0 -> ((InitiateMultipartUploadRequest)request).setSSEAwsKeyManagementParams(arg_0));
        this.generateSSECustomerKey().ifPresent(arg_0 -> ((InitiateMultipartUploadRequest)request).setSSECustomerKey(arg_0));
    }

    protected void setOptionalPutRequestParameters(PutObjectRequest request) {
        this.generateSSEAwsKeyParams().ifPresent(arg_0 -> ((PutObjectRequest)request).setSSEAwsKeyManagementParams(arg_0));
        this.generateSSECustomerKey().ifPresent(arg_0 -> ((PutObjectRequest)request).setSSECustomerKey(arg_0));
    }

    protected void setOptionalObjectMetadata(ObjectMetadata metadata, boolean isDirectoryMarker) {
        S3AEncryptionMethods algorithm = this.getServerSideEncryptionAlgorithm();
        if (S3AEncryptionMethods.SSE_S3 == algorithm) {
            metadata.setSSEAlgorithm(algorithm.getMethod());
        }
        if (this.contentEncoding != null && !isDirectoryMarker) {
            metadata.setContentEncoding(this.contentEncoding);
        }
    }

    @Override
    public ObjectMetadata newObjectMetadata(long length) {
        return this.createObjectMetadata(length, false);
    }

    private ObjectMetadata createObjectMetadata(long length, boolean isDirectoryMarker) {
        ObjectMetadata om = new ObjectMetadata();
        this.setOptionalObjectMetadata(om, isDirectoryMarker);
        if (length >= 0L) {
            om.setContentLength(length);
        }
        return om;
    }

    @Override
    public CopyObjectRequest newCopyObjectRequest(String srcKey, String dstKey, ObjectMetadata srcom) {
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.getBucket(), srcKey, this.getBucket(), dstKey);
        ObjectMetadata dstom = this.newObjectMetadata(srcom.getContentLength());
        HeaderProcessing.cloneObjectMetadata(srcom, dstom);
        this.setOptionalObjectMetadata(dstom, false);
        this.copyEncryptionParameters(srcom, copyObjectRequest);
        copyObjectRequest.setCannedAccessControlList(this.cannedACL);
        copyObjectRequest.setNewObjectMetadata(dstom);
        Optional.ofNullable(srcom.getStorageClass()).ifPresent(arg_0 -> ((CopyObjectRequest)copyObjectRequest).setStorageClass(arg_0));
        return this.prepareRequest(copyObjectRequest);
    }

    protected void copyEncryptionParameters(ObjectMetadata srcom, CopyObjectRequest copyObjectRequest) {
        String sourceKMSId = srcom.getSSEAwsKmsKeyId();
        if (StringUtils.isNotEmpty((CharSequence)sourceKMSId)) {
            LOG.debug("Propagating SSE-KMS settings from source {}", (Object)sourceKMSId);
            copyObjectRequest.setSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(sourceKMSId));
        }
        switch (this.getServerSideEncryptionAlgorithm()) {
            case SSE_S3: {
                break;
            }
            case SSE_C: {
                this.generateSSECustomerKey().ifPresent(customerKey -> {
                    copyObjectRequest.setSourceSSECustomerKey(customerKey);
                    copyObjectRequest.setDestinationSSECustomerKey(customerKey);
                });
                break;
            }
            case SSE_KMS: {
                this.generateSSEAwsKeyParams().ifPresent(arg_0 -> ((CopyObjectRequest)copyObjectRequest).setSSEAwsKeyManagementParams(arg_0));
                break;
            }
        }
    }

    @Override
    public PutObjectRequest newPutObjectRequest(String key, ObjectMetadata metadata, PutObjectOptions options, File srcfile) {
        Preconditions.checkNotNull((Object)srcfile);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.getBucket(), key, srcfile);
        this.maybeSetMetadata(options, metadata);
        this.setOptionalPutRequestParameters(putObjectRequest);
        putObjectRequest.setCannedAcl(this.cannedACL);
        if (this.storageClass != null) {
            putObjectRequest.setStorageClass(this.storageClass);
        }
        putObjectRequest.setMetadata(metadata);
        return this.prepareRequest(putObjectRequest);
    }

    @Override
    public PutObjectRequest newPutObjectRequest(String key, ObjectMetadata metadata, @Nullable PutObjectOptions options, InputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)key), (Object)"Null/empty key");
        this.maybeSetMetadata(options, metadata);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.getBucket(), key, inputStream, metadata);
        this.setOptionalPutRequestParameters(putObjectRequest);
        putObjectRequest.setCannedAcl(this.cannedACL);
        if (this.storageClass != null) {
            putObjectRequest.setStorageClass(this.storageClass);
        }
        return this.prepareRequest(putObjectRequest);
    }

    @Override
    public PutObjectRequest newDirectoryMarkerRequest(String directory) {
        String key = directory.endsWith("/") ? directory : directory + "/";
        InputStream inputStream = new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
        ObjectMetadata metadata = this.createObjectMetadata(0L, true);
        metadata.setContentType("application/x-directory");
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.getBucket(), key, inputStream, metadata);
        this.setOptionalPutRequestParameters(putObjectRequest);
        putObjectRequest.setCannedAcl(this.cannedACL);
        return this.prepareRequest(putObjectRequest);
    }

    @Override
    public ListMultipartUploadsRequest newListMultipartUploadsRequest(String prefix) {
        ListMultipartUploadsRequest request = new ListMultipartUploadsRequest(this.getBucket());
        if (prefix != null) {
            request.setPrefix(prefix);
        }
        return this.prepareRequest(request);
    }

    @Override
    public AbortMultipartUploadRequest newAbortMultipartUploadRequest(String destKey, String uploadId) {
        return this.prepareRequest(new AbortMultipartUploadRequest(this.getBucket(), destKey, uploadId));
    }

    @Override
    public InitiateMultipartUploadRequest newMultipartUploadRequest(String destKey, @Nullable PutObjectOptions options) {
        ObjectMetadata objectMetadata = this.newObjectMetadata(-1L);
        this.maybeSetMetadata(options, objectMetadata);
        InitiateMultipartUploadRequest initiateMPURequest = new InitiateMultipartUploadRequest(this.getBucket(), destKey, objectMetadata);
        initiateMPURequest.setCannedACL(this.getCannedACL());
        if (this.getStorageClass() != null) {
            initiateMPURequest.withStorageClass(this.getStorageClass());
        }
        this.setOptionalMultipartUploadRequestParameters(initiateMPURequest);
        return this.prepareRequest(initiateMPURequest);
    }

    @Override
    public CompleteMultipartUploadRequest newCompleteMultipartUploadRequest(String destKey, String uploadId, List<PartETag> partETags) {
        return this.prepareRequest(new CompleteMultipartUploadRequest(this.bucket, destKey, uploadId, new ArrayList<PartETag>(partETags)));
    }

    @Override
    public GetObjectMetadataRequest newGetObjectMetadataRequest(String key) {
        GetObjectMetadataRequest request = new GetObjectMetadataRequest(this.getBucket(), key);
        this.setOptionalGetObjectMetadataParameters(request);
        return this.prepareRequest(request);
    }

    @Override
    public GetObjectRequest newGetObjectRequest(String key) {
        GetObjectRequest request = new GetObjectRequest(this.bucket, key);
        this.generateSSECustomerKey().ifPresent(arg_0 -> ((GetObjectRequest)request).setSSECustomerKey(arg_0));
        return this.prepareRequest(request);
    }

    @Override
    public UploadPartRequest newUploadPartRequest(String destKey, String uploadId, int partNumber, int size, InputStream uploadStream, File sourceFile, long offset) throws PathIOException {
        Preconditions.checkNotNull((Object)uploadId);
        Preconditions.checkArgument((boolean)(uploadStream != null ^ sourceFile != null), (Object)"Data source");
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (String)"Invalid partition size %s", (int)size);
        Preconditions.checkArgument((partNumber > 0 ? 1 : 0) != 0, (String)"partNumber must be between 1 and %s inclusive, but is %s", (int)10000, (int)partNumber);
        LOG.debug("Creating part upload request for {} #{} size {}", new Object[]{uploadId, partNumber, size});
        String pathErrorMsg = "Number of parts in multipart upload exceeded. Current part count = %s, Part count limit = %s ";
        if ((long)partNumber > this.multipartPartCountLimit) {
            throw new PathIOException(destKey, String.format("Number of parts in multipart upload exceeded. Current part count = %s, Part count limit = %s ", partNumber, this.multipartPartCountLimit));
        }
        UploadPartRequest request = new UploadPartRequest().withBucketName(this.getBucket()).withKey(destKey).withUploadId(uploadId).withPartNumber(partNumber).withPartSize((long)size);
        if (uploadStream != null) {
            request.setInputStream(uploadStream);
        } else {
            Preconditions.checkArgument((boolean)sourceFile.exists(), (String)"Source file does not exist: %s", (Object)sourceFile);
            Preconditions.checkArgument((boolean)sourceFile.isFile(), (String)"Source is not a file: %s", (Object)sourceFile);
            Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"Invalid offset %s", (long)offset);
            long length = sourceFile.length();
            Preconditions.checkArgument((offset == 0L || offset < length ? 1 : 0) != 0, (String)"Offset %s beyond length of file %s", (long)offset, (long)length);
            request.setFile(sourceFile);
            request.setFileOffset(offset);
        }
        this.setOptionalUploadPartRequestParameters(request);
        return this.prepareRequest(request);
    }

    @Override
    public SelectObjectContentRequest newSelectRequest(String key) {
        SelectObjectContentRequest request = new SelectObjectContentRequest();
        request.setBucketName(this.bucket);
        request.setKey(key);
        this.generateSSECustomerKey().ifPresent(arg_0 -> ((SelectObjectContentRequest)request).setSSECustomerKey(arg_0));
        return this.prepareRequest(request);
    }

    @Override
    public ListObjectsRequest newListObjectsV1Request(String key, String delimiter, int maxKeys) {
        ListObjectsRequest request = new ListObjectsRequest().withBucketName(this.bucket).withMaxKeys(Integer.valueOf(maxKeys)).withPrefix(key);
        if (delimiter != null) {
            request.setDelimiter(delimiter);
        }
        return this.prepareRequest(request);
    }

    @Override
    public ListNextBatchOfObjectsRequest newListNextBatchOfObjectsRequest(ObjectListing prev) {
        return this.prepareRequest(new ListNextBatchOfObjectsRequest(prev));
    }

    @Override
    public ListObjectsV2Request newListObjectsV2Request(String key, String delimiter, int maxKeys) {
        ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(this.bucket).withMaxKeys(Integer.valueOf(maxKeys)).withPrefix(key);
        if (delimiter != null) {
            request.setDelimiter(delimiter);
        }
        return this.prepareRequest(request);
    }

    @Override
    public DeleteObjectRequest newDeleteObjectRequest(String key) {
        return this.prepareRequest(new DeleteObjectRequest(this.bucket, key));
    }

    @Override
    public DeleteObjectsRequest newBulkDeleteRequest(List<DeleteObjectsRequest.KeyVersion> keysToDelete) {
        return this.prepareRequest(new DeleteObjectsRequest(this.bucket).withKeys(keysToDelete).withQuiet(true));
    }

    @Override
    public void setEncryptionSecrets(EncryptionSecrets secrets) {
        this.encryptionSecrets = secrets;
    }

    private void maybeSetMetadata(@Nullable PutObjectOptions options, ObjectMetadata objectMetadata) {
        Map<String, String> headers;
        if (options != null && (headers = options.getHeaders()) != null) {
            objectMetadata.setUserMetadata(headers);
        }
    }

    public static RequestFactoryBuilder builder() {
        return new RequestFactoryBuilder();
    }

    @FunctionalInterface
    public static interface PrepareRequest {
        public <T extends AmazonWebServiceRequest> T prepareRequest(T var1);
    }

    public static final class RequestFactoryBuilder {
        private String bucket;
        private EncryptionSecrets encryptionSecrets = new EncryptionSecrets();
        private CannedAccessControlList cannedACL = null;
        private String contentEncoding;
        private StorageClass storageClass;
        private long multipartPartCountLimit = 10000L;
        private PrepareRequest requestPreparer;

        private RequestFactoryBuilder() {
        }

        public RequestFactory build() {
            return new RequestFactoryImpl(this);
        }

        public RequestFactoryBuilder withContentEncoding(String value) {
            this.contentEncoding = value;
            return this;
        }

        public RequestFactoryBuilder withStorageClass(StorageClass value) {
            this.storageClass = value;
            return this;
        }

        public RequestFactoryBuilder withBucket(String value) {
            this.bucket = value;
            return this;
        }

        public RequestFactoryBuilder withEncryptionSecrets(EncryptionSecrets value) {
            this.encryptionSecrets = value;
            return this;
        }

        public RequestFactoryBuilder withCannedACL(CannedAccessControlList value) {
            this.cannedACL = value;
            return this;
        }

        public RequestFactoryBuilder withMultipartPartCountLimit(long value) {
            this.multipartPartCountLimit = value;
            return this;
        }

        public RequestFactoryBuilder withRequestPreparer(PrepareRequest value) {
            this.requestPreparer = value;
            return this;
        }
    }
}

