/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.jboss.netty.handler.stream.ChunkedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FadvisedChunkedFile
extends ChunkedFile {
    private static final Logger LOG = LoggerFactory.getLogger(FadvisedChunkedFile.class);
    private final Object closeLock = new Object();
    private final boolean manageOsCache;
    private final int readaheadLength;
    private final ReadaheadPool readaheadPool;
    private final FileDescriptor fd;
    private final String identifier;
    private volatile ReadaheadPool.ReadaheadRequest readaheadRequest;

    public FadvisedChunkedFile(RandomAccessFile file, long position, long count, int chunkSize, boolean manageOsCache, int readaheadLength, ReadaheadPool readaheadPool, String identifier) throws IOException {
        super(file, position, count, chunkSize);
        this.manageOsCache = manageOsCache;
        this.readaheadLength = readaheadLength;
        this.readaheadPool = readaheadPool;
        this.fd = file.getFD();
        this.identifier = identifier;
    }

    @VisibleForTesting
    FileDescriptor getFd() {
        return this.fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object nextChunk() throws Exception {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.fd.valid()) {
                if (this.manageOsCache && this.readaheadPool != null) {
                    this.readaheadRequest = this.readaheadPool.readaheadStream(this.identifier, this.fd, this.getCurrentOffset(), (long)this.readaheadLength, this.getEndOffset(), this.readaheadRequest);
                }
                return super.nextChunk();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.readaheadRequest != null) {
                this.readaheadRequest.cancel();
                this.readaheadRequest = null;
            }
            if (this.fd.valid() && this.manageOsCache && this.getEndOffset() - this.getStartOffset() > 0L) {
                try {
                    NativeIO.POSIX.getCacheManipulator().posixFadviseIfPossible(this.identifier, this.fd, this.getStartOffset(), this.getEndOffset() - this.getStartOffset(), NativeIO.POSIX.POSIX_FADV_DONTNEED);
                }
                catch (Throwable t) {
                    LOG.warn("Failed to manage OS cache for " + this.identifier + " fd " + this.fd.toString(), t);
                }
            }
            super.close();
        }
    }
}

