/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;

public class RouterNamenodeProtocol
implements NamenodeProtocol {
    private final RouterRpcServer rpcServer;
    private final RouterRpcClient rpcClient;

    public RouterNamenodeProtocol(RouterRpcServer server) {
        this.rpcServer = server;
        this.rpcClient = this.rpcServer.getRPCClient();
    }

    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size, long minBlockSize) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        Map<String, DatanodeStorageReport[]> map = this.rpcServer.getDatanodeStorageReportMap(HdfsConstants.DatanodeReportType.ALL);
        String nsId = null;
        for (Map.Entry<String, DatanodeStorageReport[]> entry : map.entrySet()) {
            DatanodeStorageReport[] dns;
            for (DatanodeStorageReport dn : dns = entry.getValue()) {
                DatanodeInfo dnInfo = dn.getDatanodeInfo();
                if (!dnInfo.getDatanodeUuid().equals(datanode.getDatanodeUuid())) continue;
                nsId = entry.getKey();
                break;
            }
            if (nsId == null) continue;
            break;
        }
        if (nsId != null) {
            RemoteMethod method = new RemoteMethod(NamenodeProtocol.class, "getBlocks", new Class[]{DatanodeInfo.class, Long.TYPE, Long.TYPE}, datanode, size, minBlockSize);
            return this.rpcClient.invokeSingle(nsId, method, BlocksWithLocations.class);
        }
        return null;
    }

    public ExportedBlockKeys getBlockKeys() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod(NamenodeProtocol.class, "getBlockKeys");
        return this.rpcServer.invokeAtAvailableNs(method, ExportedBlockKeys.class);
    }

    public long getTransactionID() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod(NamenodeProtocol.class, "getTransactionID");
        return this.rpcServer.invokeAtAvailableNs(method, Long.TYPE);
    }

    public long getMostRecentCheckpointTxId() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod(NamenodeProtocol.class, "getMostRecentCheckpointTxId");
        return this.rpcServer.invokeAtAvailableNs(method, Long.TYPE);
    }

    public CheckpointSignature rollEditLog() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
        return null;
    }

    public NamespaceInfo versionRequest() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod(NamenodeProtocol.class, "versionRequest");
        return this.rpcServer.invokeAtAvailableNs(method, NamespaceInfo.class);
    }

    public void errorReport(NamenodeRegistration registration, int errorCode, String msg) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED, false);
    }

    public NamenodeRegistration registerSubordinateNamenode(NamenodeRegistration registration) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
        return null;
    }

    public NamenodeCommand startCheckpoint(NamenodeRegistration registration) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
        return null;
    }

    public void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
    }

    public RemoteEditLogManifest getEditLogManifest(long sinceTxId) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public boolean isUpgradeFinalized() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return false;
    }

    public boolean isRollingUpgrade() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return false;
    }

    public Long getNextSPSPath() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }
}

