/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class VersionInfo {
    private static final Log LOG = LogFactory.getLog((String)VersionInfo.class.getName());
    private static int VERY_LARGE_NUMBER = 100000;

    public static String getVersion() {
        return "1.4.8";
    }

    public static String getRevision() {
        return "91118ce5f10fb4efa03cc8c5a47c7ce97175e85e";
    }

    public static String getDate() {
        return "Tue Oct  2 12:00:02 PDT 2018";
    }

    public static String getUser() {
        return "apurtell";
    }

    public static String getUrl() {
        return "git://apurtell-ltm4.internal.salesforce.com/Users/apurtell/src/hbase";
    }

    static String[] versionReport() {
        return new String[]{"HBase " + VersionInfo.getVersion(), "Source code repository " + VersionInfo.getUrl() + " revision=" + VersionInfo.getRevision(), "Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate(), "From source with checksum " + VersionInfo.getSrcChecksum()};
    }

    public static String getSrcChecksum() {
        return "4a28ead75586c0ff5fd69ffe4d0c7692";
    }

    public static void writeTo(PrintWriter out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void writeTo(PrintStream out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void logVersion() {
        for (String line : VersionInfo.versionReport()) {
            LOG.info((Object)line);
        }
    }

    public static int compareVersion(String v1, String v2) {
        int index;
        if (v1.equals(v2)) {
            return 0;
        }
        String[] s1 = v1.split("\\.|-");
        String[] s2 = v2.split("\\.|-");
        for (index = 0; index < s1.length && index < s2.length; ++index) {
            int c;
            int va = VERY_LARGE_NUMBER;
            int vb = VERY_LARGE_NUMBER;
            try {
                va = Integer.parseInt(s1[index]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                vb = Integer.parseInt(s2[index]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (va != vb) {
                return va - vb;
            }
            if (va != VERY_LARGE_NUMBER || (c = s1[index].compareTo(s2[index])) == 0) continue;
            return c;
        }
        if (index < s1.length) {
            return 1;
        }
        return -1;
    }

    public static void main(String[] args) {
        VersionInfo.writeTo(System.out);
    }
}

