/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.records;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreBaseImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.Query;
import org.apache.hadoop.hdfs.server.federation.store.records.QueryResult;

public class MockStateStoreDriver
extends StateStoreBaseImpl {
    private boolean giveErrors = false;
    private boolean initialized = false;
    private final Map<String, Map<String, BaseRecord>> valueMap = new HashMap<String, Map<String, BaseRecord>>();

    public boolean initDriver() {
        this.initialized = true;
        return true;
    }

    public <T extends BaseRecord> boolean initRecordStorage(String className, Class<T> clazz) {
        return true;
    }

    public boolean isDriverReady() {
        return this.initialized;
    }

    public void close() throws Exception {
        this.valueMap.clear();
        this.initialized = false;
    }

    public void setGiveErrors(boolean value) {
        this.giveErrors = value;
    }

    private void checkErrors() throws IOException {
        if (this.giveErrors) {
            throw new IOException("Induced errors");
        }
    }

    public <T extends BaseRecord> QueryResult<T> get(Class<T> clazz) throws IOException {
        this.checkErrors();
        Map<String, BaseRecord> map = this.valueMap.get(StateStoreUtils.getRecordName(clazz));
        ArrayList<BaseRecord> results = map != null ? new ArrayList<BaseRecord>(map.values()) : new ArrayList();
        return new QueryResult(results, System.currentTimeMillis());
    }

    public <T extends BaseRecord> boolean putAll(List<T> records, boolean allowUpdate, boolean errorIfExists) throws IOException {
        this.checkErrors();
        for (BaseRecord record : records) {
            String key;
            Map map = this.valueMap.computeIfAbsent(StateStoreUtils.getRecordName(record.getClass()), k -> new HashMap());
            BaseRecord oldRecord = (BaseRecord)map.get(key = record.getPrimaryKey());
            if (oldRecord == null || allowUpdate) {
                map.put(key, record);
                continue;
            }
            if (!errorIfExists) continue;
            throw new IOException("Record already exists for " + record.getClass() + ": " + key);
        }
        return true;
    }

    public <T extends BaseRecord> boolean removeAll(Class<T> clazz) throws IOException {
        this.checkErrors();
        return this.valueMap.remove(StateStoreUtils.getRecordName(clazz)) != null;
    }

    public <T extends BaseRecord> int remove(Class<T> clazz, Query<T> query) throws IOException {
        this.checkErrors();
        int result = 0;
        Map<String, BaseRecord> map = this.valueMap.get(StateStoreUtils.getRecordName(clazz));
        if (map != null) {
            Iterator<BaseRecord> itr = map.values().iterator();
            while (itr.hasNext()) {
                BaseRecord record = itr.next();
                if (!query.matches(record)) continue;
                itr.remove();
                ++result;
            }
        }
        return result;
    }
}

