/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.contract.router.SecurityConfUtil;
import org.apache.hadoop.fs.contract.router.web.RouterWebHDFSContract;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestRouterWithSecureStartup {
    private static final String HTTP_KERBEROS_PRINCIPAL_CONF_KEY = "hadoop.http.authentication.kerberos.principal";
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Test
    public void testStartupWithoutSpnegoPrincipal() throws Exception {
        Configuration conf = SecurityConfUtil.initSecurity();
        conf.unset(HTTP_KERBEROS_PRINCIPAL_CONF_KEY);
        RouterWebHDFSContract.createCluster(conf);
        Assert.assertNotNull((Object)RouterWebHDFSContract.getCluster());
    }

    @Test
    public void testStartupWithoutKeytab() throws Exception {
        this.testCluster("dfs.federation.router.keytab.file", "Running in secure mode, but config doesn't have a keytab");
    }

    @Test
    public void testSuccessfulStartup() throws Exception {
        Configuration conf = SecurityConfUtil.initSecurity();
        RouterWebHDFSContract.createCluster(conf);
        Assert.assertNotNull((Object)RouterWebHDFSContract.getCluster());
    }

    private void testCluster(String configToTest, String message) throws Exception {
        Configuration conf = SecurityConfUtil.initSecurity();
        conf.unset(configToTest);
        this.exceptionRule.expect(IOException.class);
        this.exceptionRule.expectMessage(message);
        RouterWebHDFSContract.createCluster(conf);
    }
}

