/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.internal.directconnectivity.Protocol;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configs {
    private static final Logger logger = LoggerFactory.getLogger(Configs.class);
    private final SslContext sslContext = this.sslContextInit();
    private static final String PROTOCOL = "COSMOS.PROTOCOL";
    private static final Protocol DEFAULT_PROTOCOL = Protocol.Https;
    private static final String UNAVAILABLE_LOCATIONS_EXPIRATION_TIME_IN_SECONDS = "COSMOS.UNAVAILABLE_LOCATIONS_EXPIRATION_TIME_IN_SECONDS";
    private static final String MAX_HTTP_BODY_LENGTH_IN_BYTES = "COSMOS.MAX_HTTP_BODY_LENGTH_IN_BYTES";
    private static final String MAX_HTTP_INITIAL_LINE_LENGTH_IN_BYTES = "COSMOS.MAX_HTTP_INITIAL_LINE_LENGTH_IN_BYTES";
    private static final String MAX_HTTP_CHUNK_SIZE_IN_BYTES = "COSMOS.MAX_HTTP_CHUNK_SIZE_IN_BYTES";
    private static final String MAX_HTTP_HEADER_SIZE_IN_BYTES = "COSMOS.MAX_HTTP_HEADER_SIZE_IN_BYTES";
    private static final String MAX_DIRECT_HTTPS_POOL_SIZE = "COSMOS.MAX_DIRECT_HTTP_CONNECTION_LIMIT";
    private static final int DEFAULT_UNAVAILABLE_LOCATIONS_EXPIRATION_TIME_IN_SECONDS = 300;
    private static final int DEFAULT_MAX_HTTP_BODY_LENGTH_IN_BYTES = 0x600000;
    private static final int DEFAULT_MAX_HTTP_INITIAL_LINE_LENGTH = 4096;
    private static final int DEFAULT_MAX_HTTP_CHUNK_SIZE_IN_BYTES = 8192;
    private static final int DEFAULT_MAX_HTTP_REQUEST_HEADER_SIZE = 32768;
    private static final int MAX_NUMBER_OF_READ_BARRIER_READ_RETRIES = 6;
    private static final int MAX_NUMBER_OF_PRIMARY_READ_RETRIES = 6;
    private static final int MAX_NUMBER_OF_READ_QUORUM_RETRIES = 6;
    private static final int DELAY_BETWEEN_READ_BARRIER_CALLS_IN_MS = 5;
    private static final int MAX_BARRIER_RETRIES_FOR_MULTI_REGION = 30;
    private static final int BARRIER_RETRY_INTERVAL_IN_MS_FOR_MULTI_REGION = 30;
    private static final int MAX_SHORT_BARRIER_RETRIES_FOR_MULTI_REGION = 4;
    private static final int SHORT_BARRIER_RETRY_INTERVAL_IN_MS_FOR_MULTI_REGION = 10;
    private static final int CPU_CNT = Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_DIRECT_HTTPS_POOL_SIZE = CPU_CNT * 500;

    private SslContext sslContextInit() {
        try {
            SslProvider sslProvider = SslContext.defaultClientProvider();
            return SslContextBuilder.forClient().sslProvider(sslProvider).build();
        }
        catch (SSLException sslException) {
            logger.error("Fatal error cannot instantiate ssl context due to {}", (Object)sslException.getMessage(), (Object)sslException);
            throw new IllegalStateException(sslException);
        }
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public Protocol getProtocol() {
        String protocol = Configs.getJVMConfigAsString(PROTOCOL, DEFAULT_PROTOCOL.name());
        try {
            return Protocol.valueOf(WordUtils.capitalize((String)protocol.toLowerCase()));
        }
        catch (Exception e) {
            logger.error("Parsing protocol {} failed. Using the default {}.", new Object[]{protocol, DEFAULT_PROTOCOL, e});
            return DEFAULT_PROTOCOL;
        }
    }

    public int getMaxNumberOfReadBarrierReadRetries() {
        return 6;
    }

    public int getMaxNumberOfPrimaryReadRetries() {
        return 6;
    }

    public int getMaxNumberOfReadQuorumRetries() {
        return 6;
    }

    public int getDelayBetweenReadBarrierCallsInMs() {
        return 5;
    }

    public int getMaxBarrierRetriesForMultiRegion() {
        return 30;
    }

    public int getBarrierRetryIntervalInMsForMultiRegion() {
        return 30;
    }

    public int getMaxShortBarrierRetriesForMultiRegion() {
        return 4;
    }

    public int getShortBarrierRetryIntervalInMsForMultiRegion() {
        return 10;
    }

    public int getDirectHttpsMaxConnectionLimit() {
        return Configs.getJVMConfigAsInt(MAX_DIRECT_HTTPS_POOL_SIZE, DEFAULT_DIRECT_HTTPS_POOL_SIZE);
    }

    public int getMaxHttpHeaderSize() {
        return Configs.getJVMConfigAsInt(MAX_HTTP_HEADER_SIZE_IN_BYTES, 32768);
    }

    public int getMaxHttpInitialLineLength() {
        return Configs.getJVMConfigAsInt(MAX_HTTP_INITIAL_LINE_LENGTH_IN_BYTES, 4096);
    }

    public int getMaxHttpChunkSize() {
        return Configs.getJVMConfigAsInt(MAX_HTTP_CHUNK_SIZE_IN_BYTES, 8192);
    }

    public int getMaxHttpBodyLength() {
        return Configs.getJVMConfigAsInt(MAX_HTTP_BODY_LENGTH_IN_BYTES, 0x600000);
    }

    public int getUnavailableLocationsExpirationTimeInSeconds() {
        return Configs.getJVMConfigAsInt(UNAVAILABLE_LOCATIONS_EXPIRATION_TIME_IN_SECONDS, 300);
    }

    private static String getJVMConfigAsString(String propName, String defaultValue) {
        String propValue = System.getProperty(propName);
        return StringUtils.defaultString((String)propValue, (String)defaultValue);
    }

    private static int getJVMConfigAsInt(String propName, int defaultValue) {
        String propValue = System.getProperty(propName);
        return Configs.getIntValue(propValue, defaultValue);
    }

    private static int getIntValue(String val, int defaultValue) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            return defaultValue;
        }
        return Integer.valueOf(val);
    }
}

