/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.types.TimestampData;

public class HsqlDateTime {
    public static final Locale defaultLocale = Locale.UK;
    private static final Calendar tempCalDefault = new GregorianCalendar();
    private static final Calendar tempCalGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale);
    private static final String sdfdPattern = "yyyy-MM-dd";
    private static final SimpleDateFormat sdfd = new SimpleDateFormat("yyyy-MM-dd", defaultLocale);
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat sdfts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", defaultLocale);
    private static final String sdftsSysPattern = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final SimpleDateFormat sdftsSys = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", defaultLocale);
    private static final Date sysDate = new Date();
    private static final char[][] dateTokens;
    private static final String[] javaDateTokens;
    private static final int[] sqlIntervalCodes;
    private static final char e = '\uffff';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDateSeconds(String string) {
        try {
            SimpleDateFormat simpleDateFormat = sdfd;
            synchronized (simpleDateFormat) {
                Date date = sdfd.parse(string);
                return date.getTime() / 1000L;
            }
        }
        catch (Exception exception) {
            throw Error.error(3407, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateString(long l) {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sysDate.setTime(l * 1000L);
            return sdfd.format(sysDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimestampSeconds(String string) {
        try {
            SimpleDateFormat simpleDateFormat = sdfts;
            synchronized (simpleDateFormat) {
                Date date = sdfts.parse(string);
                return date.getTime() / 1000L;
            }
        }
        catch (Exception exception) {
            throw Error.error(3407, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(long l, int n, int n2) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sysDate.setTime(l * 1000L);
            String string = sdfts.format(sysDate);
            if (n2 > 0) {
                string = string + '.' + StringUtil.toZeroPaddedString(n, 9, n2);
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(long l) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sysDate.setTime(l);
            return sdfts.format(sysDate);
        }
    }

    private static void resetToDate(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    private static void resetToTime(Calendar calendar) {
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(14, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisToCalendar(Calendar calendar, long l) {
        Calendar calendar2 = tempCalGMT;
        synchronized (calendar2) {
            Calendar calendar3 = calendar;
            synchronized (calendar3) {
                calendar.clear();
                tempCalGMT.setTimeInMillis(l);
                calendar.set(tempCalGMT.get(1), tempCalGMT.get(2), tempCalGMT.get(5), tempCalGMT.get(11), tempCalGMT.get(12), tempCalGMT.get(13));
                return calendar.getTimeInMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisFromCalendar(Calendar calendar, Calendar calendar2, long l) {
        Calendar calendar3 = calendar2;
        synchronized (calendar3) {
            Calendar calendar4 = calendar;
            synchronized (calendar4) {
                calendar2.clear();
                calendar.setTimeInMillis(l);
                calendar2.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
                return calendar2.getTimeInMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertSecondsFromCalendar(Calendar calendar, Calendar calendar2, long l) {
        Calendar calendar3 = calendar2;
        synchronized (calendar3) {
            Calendar calendar4 = calendar;
            synchronized (calendar4) {
                calendar2.clear();
                calendar.setTimeInMillis(l * 1000L);
                calendar2.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
                return calendar2.getTimeInMillis() / 1000L;
            }
        }
    }

    public static void setTimeInMillis(Calendar calendar, long l) {
        calendar.setTimeInMillis(l);
    }

    public static long convertToNormalisedTime(long l) {
        return HsqlDateTime.convertToNormalisedTime(tempCalGMT, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToNormalisedTime(Calendar calendar, long l) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l);
            HsqlDateTime.resetToDate(calendar);
            long l2 = calendar.getTimeInMillis();
            return l - l2;
        }
    }

    public static long getNormalisedTime(long l) {
        return HsqlDateTime.getNormalisedTime(tempCalGMT, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(Calendar calendar, long l) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l);
            HsqlDateTime.resetToTime(calendar);
            return calendar.getTimeInMillis();
        }
    }

    public static long getNormalisedDate(long l) {
        return HsqlDateTime.getNormalisedDate(tempCalGMT, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(Calendar calendar, long l) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l);
            HsqlDateTime.resetToDate(calendar);
            return calendar.getTimeInMillis();
        }
    }

    public static int getZoneSeconds() {
        return HsqlDateTime.getZoneSeconds(tempCalDefault);
    }

    public static int getZoneSeconds(Calendar calendar) {
        return (calendar.get(15) + calendar.get(16)) / 1000;
    }

    public static int getZoneMillis(Calendar calendar, long l) {
        return calendar.getTimeZone().getOffset(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTruncatedPart(Calendar calendar, long l, int n) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(l);
            switch (n) {
                case 136: {
                    int n2 = calendar.get(7);
                    if (n2 == 1) {
                        n2 = 8;
                    }
                    calendar.add(6, 2 - n2);
                    HsqlDateTime.resetToDate(calendar);
                    break;
                }
                case 126: {
                    int n3 = calendar.get(7);
                    calendar.add(6, 1 - n3);
                    HsqlDateTime.resetToDate(calendar);
                    break;
                }
                default: {
                    HsqlDateTime.zeroFromPart(calendar, n);
                }
            }
            return calendar.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRoundedPart(Calendar calendar, long l, int n) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(l);
            switch (n) {
                case 101: {
                    if (calendar.get(2) <= 6) break;
                    calendar.add(1, 1);
                    break;
                }
                case 102: {
                    if (calendar.get(5) <= 15) break;
                    calendar.add(2, 1);
                    break;
                }
                case 103: {
                    if (calendar.get(11) <= 11) break;
                    calendar.add(5, 1);
                    break;
                }
                case 104: {
                    if (calendar.get(12) <= 29) break;
                    calendar.add(11, 1);
                    break;
                }
                case 105: {
                    if (calendar.get(13) <= 29) break;
                    calendar.add(12, 1);
                    break;
                }
                case 106: {
                    if (calendar.get(14) <= 499) break;
                    calendar.add(13, 1);
                    break;
                }
                case 126: {
                    int n2 = calendar.get(6);
                    int n3 = calendar.get(1);
                    int n4 = calendar.get(3);
                    int n5 = calendar.get(7);
                    calendar.clear();
                    calendar.set(1, n3);
                    if (n5 > 3) {
                        ++n4;
                    }
                    if (n4 == 1 && (n2 > 356 || n2 < 7)) {
                        calendar.set(6, n2);
                        while (true) {
                            if (calendar.get(7) == 1) {
                                return calendar.getTimeInMillis();
                            }
                            calendar.add(6, -1);
                        }
                    }
                    calendar.set(3, n4);
                    return calendar.getTimeInMillis();
                }
            }
            HsqlDateTime.zeroFromPart(calendar, n);
            return calendar.getTimeInMillis();
        }
    }

    public static void zeroFromPart(Calendar calendar, int n) {
        switch (n) {
            case 101: {
                calendar.set(2, 0);
            }
            case 102: {
                calendar.set(5, 1);
            }
            case 103: {
                calendar.set(11, 0);
            }
            case 104: {
                calendar.set(12, 0);
            }
            case 105: {
                calendar.set(13, 0);
            }
            case 106: {
                calendar.set(14, 0);
            }
        }
    }

    public static TimestampData toDate(String string, String string2, SimpleDateFormat simpleDateFormat, boolean bl) {
        long l;
        int n = 0;
        String string3 = HsqlDateTime.toJavaDatePattern(string2);
        String string4 = null;
        int n2 = string3.indexOf("*IY");
        if (n2 >= 0) {
            throw Error.error(3472);
        }
        n2 = string3.indexOf("*WW");
        if (n2 >= 0) {
            throw Error.error(3472);
        }
        n2 = string3.indexOf("*W");
        if (n2 >= 0) {
            throw Error.error(3472);
        }
        n2 = string3.indexOf("SSS");
        if (n2 >= 0) {
            string4 = string3;
            string3 = string3.substring(0, n2) + string3.substring(n2 + 3);
        }
        try {
            simpleDateFormat.applyPattern(string3);
            l = simpleDateFormat.parse(string).getTime();
        }
        catch (Exception exception) {
            throw Error.error(exception, 3407, exception.toString());
        }
        if (n2 >= 0 && bl) {
            string3 = string4;
            try {
                simpleDateFormat.applyPattern(string3);
                long l2 = simpleDateFormat.parse(string).getTime();
                int n3 = 1;
                n = (int)(l2 -= l);
                while (l2 > 1000L) {
                    l2 /= 10L;
                    n3 *= 10;
                }
                n *= 1000000 / n3;
            }
            catch (Exception exception) {
                throw Error.error(exception, 3407, exception.toString());
            }
        }
        return new TimestampData(l / 1000L, n, 0);
    }

    public static String toFormattedDate(Date date, String string, SimpleDateFormat simpleDateFormat) {
        CharSequence charSequence;
        int n;
        int n2;
        int n3;
        Calendar calendar;
        String string2 = HsqlDateTime.toJavaDatePattern(string);
        try {
            simpleDateFormat.applyPattern(string2);
        }
        catch (Exception exception) {
            throw Error.error(3472, exception);
        }
        String string3 = simpleDateFormat.format(date);
        int n4 = string3.indexOf("*IY");
        if (n4 >= 0) {
            calendar = simpleDateFormat.getCalendar();
            n3 = 3;
            n2 = string3.indexOf("*IYYY");
            if (n2 >= 0) {
                n3 = 5;
                n4 = n2;
            }
            n = calendar.get(1);
            int n5 = calendar.get(3);
            if (n5 == 1 && calendar.get(6) > 360) {
                ++n;
            } else if (n5 > 51 && calendar.get(6) < 4) {
                --n;
            }
            charSequence = String.valueOf(n);
            if (n3 == 3) {
                charSequence = ((String)charSequence).substring(((String)charSequence).length() - 2);
            }
            StringBuilder stringBuilder = new StringBuilder(string3);
            stringBuilder.replace(n4, n4 + n3, (String)charSequence);
            string3 = stringBuilder.toString();
        }
        if ((n4 = string3.indexOf("*WW")) >= 0) {
            calendar = simpleDateFormat.getCalendar();
            n3 = 3;
            n2 = calendar.get(6);
            n = (n2 - 1) / 7 + 1;
            String string4 = String.valueOf(n);
            if (string4.length() == 1) {
                string4 = "0" + string4;
            }
            charSequence = new StringBuilder(string3);
            ((StringBuilder)charSequence).replace(n4, n4 + n3, string4);
            string3 = ((StringBuilder)charSequence).toString();
        }
        if ((n4 = string3.indexOf("*IW")) >= 0) {
            calendar = simpleDateFormat.getCalendar();
            n3 = 3;
            n2 = calendar.get(3);
            String string5 = String.valueOf(n2);
            if (string5.length() == 1) {
                string5 = "0" + string5;
            }
            StringBuilder stringBuilder = new StringBuilder(string3);
            stringBuilder.replace(n4, n4 + n3, string5);
            string3 = stringBuilder.toString();
        }
        if ((n4 = string3.indexOf("*W")) >= 0) {
            calendar = simpleDateFormat.getCalendar();
            n3 = 2;
            n2 = calendar.get(5);
            int n6 = (n2 - 1) / 7 + 1;
            StringBuilder stringBuilder = new StringBuilder(string3);
            stringBuilder.replace(n4, n4 + n3, String.valueOf(n6));
            string3 = stringBuilder.toString();
        }
        return string3;
    }

    public static String toJavaDatePattern(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        Tokenizer tokenizer = new Tokenizer();
        int n2 = -1;
        for (int i = 0; i <= n; ++i) {
            char c;
            char c2 = c = i == n ? (char)'\uffff' : (char)string.charAt(i);
            if (tokenizer.isInQuotes()) {
                if (tokenizer.isQuoteChar(c)) {
                    c = '\'';
                } else if (c == '\'') {
                    stringBuilder.append(c);
                }
                stringBuilder.append(c);
                continue;
            }
            if (tokenizer.next(c, i)) continue;
            if (tokenizer.consumed) {
                int n3 = tokenizer.getLastMatch();
                String string2 = javaDateTokens[n3];
                if (string2.startsWith("'") && string2.endsWith("'")) {
                    if (n2 == stringBuilder.length()) {
                        stringBuilder.setLength(stringBuilder.length() - 1);
                        string2 = string2.substring(1);
                    }
                    n2 = stringBuilder.length() + string2.length();
                }
                stringBuilder.append(string2);
                i = tokenizer.matchOffset;
            } else if (tokenizer.isQuoteChar(c)) {
                c = '\'';
                stringBuilder.append(c);
            } else if (tokenizer.isLiteral(c)) {
                stringBuilder.append(c);
            } else if (c != '\uffff') {
                throw Error.error(3407, string.substring(i));
            }
            tokenizer.reset();
        }
        if (tokenizer.isInQuotes()) {
            throw Error.error(3407);
        }
        String string3 = stringBuilder.toString();
        return string3;
    }

    public static int toStandardIntervalPart(String string) {
        int n = string.length();
        Tokenizer tokenizer = new Tokenizer();
        for (int i = 0; i <= n; ++i) {
            char c;
            char c2 = c = i == n ? (char)'\uffff' : (char)string.charAt(i);
            if (tokenizer.next(c, i)) continue;
            int n2 = tokenizer.getLastMatch();
            if (n2 >= 0) {
                return sqlIntervalCodes[n2];
            }
            return -1;
        }
        return -1;
    }

    static /* synthetic */ char[][] access$200() {
        return dateTokens;
    }

    static {
        TimeZone.getDefault();
        tempCalGMT.setLenient(false);
        sdfd.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdfd.setLenient(false);
        sdfts.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdfts.setLenient(false);
        dateTokens = new char[][]{{'R', 'R', 'R', 'R'}, {'I', 'Y', 'Y', 'Y'}, {'Y', 'Y', 'Y', 'Y'}, {'I', 'Y'}, {'Y', 'Y'}, {'B', 'C'}, {'B', '.', 'C', '.'}, {'A', 'D'}, {'A', '.', 'D', '.'}, {'M', 'O', 'N'}, {'M', 'O', 'N', 'T', 'H'}, {'M', 'M'}, {'D', 'A', 'Y'}, {'D', 'Y'}, {'W', 'W'}, {'I', 'W'}, {'D', 'D'}, {'D', 'D', 'D'}, {'W'}, {'H', 'H', '2', '4'}, {'H', 'H', '1', '2'}, {'H', 'H'}, {'M', 'I'}, {'S', 'S'}, {'A', 'M'}, {'P', 'M'}, {'A', '.', 'M', '.'}, {'P', '.', 'M', '.'}, {'F', 'F'}};
        javaDateTokens = new String[]{"yyyy", "'*IYYY'", "yyyy", "'*IY'", "yy", "G", "G", "G", "G", "MMM", "MMMMM", "MM", "EEEE", "EE", "'*WW'", "'*IW'", "dd", "D", "'*W'", "HH", "KK", "KK", "mm", "ss", "aaa", "aaa", "aaa", "aaa", "SSS"};
        sqlIntervalCodes = new int[]{-1, -1, 101, -1, 101, -1, -1, -1, -1, 102, 102, 102, -1, -1, 126, 136, 103, 103, -1, 104, -1, 104, 105, 106, -1, -1, -1, -1, -1};
    }

    static class Tokenizer {
        private int lastMatched;
        private int matchOffset;
        private int offset;
        private long state;
        private boolean consumed;
        private boolean isInQuotes;
        private boolean matched;
        private final char quoteChar = (char)34;
        private final char[] literalChars = defaultLiterals;
        private static char[] defaultLiterals = new char[]{' ', ',', '-', '.', '/', ':', ';'};
        char[][] tokens = HsqlDateTime.access$200();

        public Tokenizer() {
            this.reset();
        }

        public void reset() {
            this.lastMatched = -1;
            this.offset = -1;
            this.state = 0L;
            this.consumed = false;
            this.matched = false;
        }

        public int length() {
            return this.offset;
        }

        public int getLastMatch() {
            return this.lastMatched;
        }

        public boolean isConsumed() {
            return this.consumed;
        }

        public boolean wasMatched() {
            return this.matched;
        }

        public boolean isInQuotes() {
            return this.isInQuotes;
        }

        public boolean isQuoteChar(char c) {
            if (this.quoteChar == c) {
                this.isInQuotes = !this.isInQuotes;
                return true;
            }
            return false;
        }

        public boolean isLiteral(char c) {
            return ArrayUtil.isInSortedArray(c, this.literalChars);
        }

        private boolean isZeroBit(int n) {
            return (this.state & 1L << n) == 0L;
        }

        private void setBit(int n) {
            this.state |= 1L << n;
        }

        public boolean next(char c, int n) {
            int n2 = ++this.offset;
            int n3 = this.offset + 1;
            int n4 = 0;
            this.matched = false;
            int n5 = this.tokens.length;
            while (--n5 >= 0) {
                if (!this.isZeroBit(n5)) continue;
                if (this.tokens[n5][n2] == Character.toUpperCase(c)) {
                    if (this.tokens[n5].length == n3) {
                        this.setBit(n5);
                        this.lastMatched = n5;
                        this.consumed = true;
                        this.matched = true;
                        this.matchOffset = n;
                        continue;
                    }
                    ++n4;
                    continue;
                }
                this.setBit(n5);
            }
            return n4 > 0;
        }
    }

    public static class SystemTimeString {
        private Date date = new Date();
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        public SystemTimeString() {
            this.dateFormat.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
            this.dateFormat.setLenient(false);
        }

        public synchronized String getTimestampString() {
            this.date.setTime(System.currentTimeMillis());
            return this.dateFormat.format(this.date);
        }
    }
}

