/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobStatusChanged;
import org.apache.hadoop.shaded.org.apache.avro.util.Utf8;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobStatusChangedEvent
implements HistoryEvent {
    private JobStatusChanged datum = new JobStatusChanged();

    public JobStatusChangedEvent(JobID id, String jobStatus) {
        this.datum.setJobid((CharSequence)new Utf8(id.toString()));
        this.datum.setJobStatus((CharSequence)new Utf8(jobStatus));
    }

    JobStatusChangedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobStatusChanged)((Object)datum);
    }

    public JobID getJobId() {
        return JobID.forName(this.datum.getJobid().toString());
    }

    public String getStatus() {
        return this.datum.getJobStatus().toString();
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_STATUS_CHANGED;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("STATUS", this.getStatus());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        return null;
    }
}

