/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestSuccessData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbstractJobOrTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CleanupJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CreateOutputDirectoriesStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.LoadManifestsStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.RenameFilesStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.SaveSuccessFileStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.ValidateRenamedFilesStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitJobStage
extends AbstractJobOrTaskStage<Arguments, Result> {
    private static final Logger LOG = LoggerFactory.getLogger(CommitJobStage.class);

    public CommitJobStage(StageConfig stageConfig) {
        super(false, stageConfig, "committer_commit_job", true);
    }

    @Override
    protected Result executeStage(Arguments arguments) throws IOException {
        LOG.info("{}: Committing job \"{}\". resilient commit supported = {}", new Object[]{this.getName(), this.getJobId(), this.storeSupportsResilientCommit()});
        boolean createMarker = arguments.isCreateMarker();
        StageConfig stageConfig = this.getStageConfig();
        LoadManifestsStage.Result result = (LoadManifestsStage.Result)new LoadManifestsStage(stageConfig).apply(true);
        List<TaskManifest> manifests = result.getManifests();
        LoadManifestsStage.SummaryInfo summary = result.getSummary();
        LOG.debug("{}: Job Summary {}", (Object)this.getName(), (Object)summary);
        LOG.info("{}: Committing job with file count: {}; total size {} bytes", new Object[]{this.getName(), summary.getFileCount(), FileUtils.byteCountToDisplaySize((long)summary.getTotalFileSize())});
        IOStatisticsStore iostats = this.getIOStatistics();
        iostats.aggregate((IOStatistics)summary.getIOStatistics());
        CreateOutputDirectoriesStage.Result dirStageResults = (CreateOutputDirectoriesStage.Result)new CreateOutputDirectoriesStage(stageConfig).apply(manifests);
        ManifestSuccessData successData = (ManifestSuccessData)new RenameFilesStage(stageConfig).apply(Pair.of(manifests, dirStageResults.getCreatedDirectories()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: _SUCCESS file summary {}", (Object)this.getName(), (Object)successData.toJson());
        }
        iostats.setCounter("committer_files_committed", summary.getFileCount());
        iostats.setCounter("committer_bytes_committed", summary.getTotalFileSize());
        successData.snapshotIOStatistics((IOStatistics)iostats);
        String manifestRenameDir = arguments.getManifestRenameDir();
        if (StringUtils.isNotBlank((CharSequence)manifestRenameDir)) {
            Path manifestRenamePath = new Path(new Path(manifestRenameDir), this.getJobId());
            LOG.info("{}: Renaming manifests to {}", (Object)this.getName(), (Object)manifestRenamePath);
            try {
                this.renameDir(this.getTaskManifestDir(), manifestRenamePath);
                successData.getDiagnostics().put("manifests", manifestRenamePath.toUri().toString());
            }
            catch (IOException | IllegalArgumentException e) {
                LOG.warn("{}: Failed to rename manifests to {}", new Object[]{this.getName(), manifestRenamePath, e});
            }
        }
        Path successPath = null;
        if (createMarker) {
            successPath = (Path)new SaveSuccessFileStage(stageConfig).apply(successData);
            LOG.debug("{}: Saving _SUCCESS file to {}", (Object)this.getName(), (Object)successPath);
        }
        new CleanupJobStage(stageConfig).apply(arguments.getCleanupArguments());
        if (arguments.isValidateOutput()) {
            LOG.info("{}: Validating output.", (Object)this.getName());
            new ValidateRenamedFilesStage(stageConfig).apply(result.getManifests());
        }
        stageConfig.enterStage(this.getStageName(arguments));
        return new Result(successPath, successData);
    }

    public static final class Result {
        private final ManifestSuccessData jobSuccessData;
        private final Path successPath;

        public Result(Path successPath, ManifestSuccessData jobSuccessData) {
            this.successPath = successPath;
            this.jobSuccessData = jobSuccessData;
        }

        public ManifestSuccessData getJobSuccessData() {
            return this.jobSuccessData;
        }

        public Path getSuccessPath() {
            return this.successPath;
        }
    }

    public static final class Arguments {
        private final boolean createMarker;
        private final boolean validateOutput;
        private final String manifestRenameDir;
        private final CleanupJobStage.Arguments cleanupArguments;

        public Arguments(boolean createMarker, boolean validateOutput, @Nullable String manifestRenameDir, CleanupJobStage.Arguments cleanupArguments) {
            this.createMarker = createMarker;
            this.validateOutput = validateOutput;
            this.manifestRenameDir = manifestRenameDir;
            this.cleanupArguments = Objects.requireNonNull(cleanupArguments);
        }

        public boolean isCreateMarker() {
            return this.createMarker;
        }

        public boolean isValidateOutput() {
            return this.validateOutput;
        }

        public String getManifestRenameDir() {
            return this.manifestRenameDir;
        }

        public CleanupJobStage.Arguments getCleanupArguments() {
            return this.cleanupArguments;
        }
    }
}

