/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin;

import java.io.Serializable;
import java.util.Objects;

public final class VolumeSpec
implements Serializable,
Comparable {
    private static final long serialVersionUID = 3483619025106416736L;
    private final String volumeDriver;
    private final String volumeName;
    private final String volumeOperation;
    public static final String CREATE = "create";
    public static final String DELETE = "delete";

    private VolumeSpec(Builder builder) {
        this.volumeDriver = builder.volumeDriver;
        this.volumeName = builder.volumeName;
        this.volumeOperation = builder.volumeOperation;
    }

    public String getVolumeDriver() {
        return this.volumeDriver;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getVolumeOperation() {
        return this.volumeOperation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeSpec other = (VolumeSpec)o;
        return Objects.equals(this.volumeDriver, other.getVolumeDriver()) && Objects.equals(this.volumeName, other.getVolumeName()) && Objects.equals(this.volumeOperation, other.getVolumeOperation());
    }

    public int hashCode() {
        return Objects.hash(this.volumeDriver, this.volumeName, this.volumeOperation);
    }

    public int compareTo(Object o) {
        return 0;
    }

    public static final class Builder {
        private String volumeDriver;
        private String volumeName;
        private String volumeOperation;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public VolumeSpec build() {
            return new VolumeSpec(this);
        }

        public Builder setVolumeDriver(String volDriver) {
            this.volumeDriver = volDriver;
            return this;
        }

        public Builder setVolumeName(String volName) {
            this.volumeName = volName;
            return this;
        }

        public Builder setVolumeOperation(String volOperation) {
            this.volumeOperation = volOperation;
            return this;
        }
    }
}

