/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.B2CConverter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.BufferChunk;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.ByteChunk;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.CharChunk;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.DataChunk;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.MessageBytes;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.UDecoder;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.URLDecoder;
import org.apache.hadoop.shaded.org.glassfish.grizzly.utils.Charsets;

public class HttpRequestURIDecoder {
    protected static final boolean ALLOW_BACKSLASH = false;
    private static final boolean COLLAPSE_ADJACENT_SLASHES = Boolean.valueOf(System.getProperty("org.apache.hadoop.shaded.com.sun.enterprise.web.collapseAdjacentSlashes", "true"));
    private static final Logger LOGGER = Grizzly.logger(HttpRequestURIDecoder.class);
    private static final int STATE_CHAR = 0;
    private static final int STATE_SLASH = 1;
    private static final int STATE_PERCENT = 2;
    private static final int STATE_SLASHDOT = 3;
    private static final int STATE_SLASHDOTDOT = 4;

    public static void decode(MessageBytes decodedURI, UDecoder urlDecoder) throws Exception {
        HttpRequestURIDecoder.decode(decodedURI, urlDecoder, null, null);
    }

    public static void decode(MessageBytes decodedURI, UDecoder urlDecoder, String encoding, B2CConverter b2cConverter) throws Exception {
        urlDecoder.convert(decodedURI, false);
        if (!HttpRequestURIDecoder.normalize(decodedURI)) {
            throw new IOException("Invalid URI character encoding");
        }
        if (encoding == null) {
            encoding = "utf-8";
        }
        HttpRequestURIDecoder.convertURI(decodedURI, encoding, b2cConverter);
        if (!HttpRequestURIDecoder.checkNormalize(decodedURI.getCharChunk())) {
            throw new IOException("Invalid URI character encoding");
        }
    }

    public static void decode(DataChunk decodedURI) throws CharConversionException {
        HttpRequestURIDecoder.decode(decodedURI, false, Charsets.UTF8_CHARSET);
    }

    public static void decode(DataChunk decodedURI, boolean isSlashAllowed) throws CharConversionException {
        HttpRequestURIDecoder.decode(decodedURI, isSlashAllowed, Charsets.UTF8_CHARSET);
    }

    public static void decode(DataChunk decodedURI, boolean isSlashAllowed, Charset encoding) throws CharConversionException {
        HttpRequestURIDecoder.decode(decodedURI, decodedURI, isSlashAllowed, encoding);
    }

    public static void decode(DataChunk originalURI, DataChunk targetDecodedURI, boolean isSlashAllowed, Charset encoding) throws CharConversionException {
        URLDecoder.decode(originalURI, targetDecodedURI, isSlashAllowed);
        if (!HttpRequestURIDecoder.normalize(targetDecodedURI)) {
            throw new CharConversionException("Invalid URI character encoding");
        }
        HttpRequestURIDecoder.convertToChars(targetDecodedURI, encoding);
    }

    public static void convertToChars(DataChunk decodedURI, Charset encoding) throws CharConversionException {
        if (encoding == null) {
            encoding = Charsets.UTF8_CHARSET;
        }
        decodedURI.toChars(encoding);
        if (!HttpRequestURIDecoder.checkNormalize(decodedURI.getCharChunk())) {
            throw new CharConversionException("Invalid URI character encoding");
        }
    }

    private static void convertURI(MessageBytes uri, String encoding, B2CConverter b2cConverter) throws Exception {
        ByteChunk bc = uri.getByteChunk();
        CharChunk cc = uri.getCharChunk();
        cc.allocate(bc.getLength(), -1);
        if (encoding != null && encoding.trim().length() != 0 && !"ISO-8859-1".equalsIgnoreCase(encoding)) {
            try {
                if (b2cConverter == null) {
                    b2cConverter = new B2CConverter(encoding);
                }
            }
            catch (IOException e) {
                LOGGER.severe("Invalid URI encoding; using HTTP default");
            }
            if (b2cConverter != null) {
                try {
                    b2cConverter.convert(bc, cc);
                    uri.setChars(cc.getBuffer(), cc.getStart(), cc.getLength());
                    return;
                }
                catch (IOException e) {
                    LOGGER.severe("Invalid URI character encoding; trying ascii");
                    cc.recycle();
                }
            }
        }
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < bc.getLength(); ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        uri.setChars(cbuf, 0, bc.getLength());
    }

    public static boolean normalize(MessageBytes uriMB) {
        int type = uriMB.getType();
        if (type == 3) {
            return HttpRequestURIDecoder.normalizeChars(uriMB.getCharChunk());
        }
        return HttpRequestURIDecoder.normalizeBytes(uriMB.getByteChunk());
    }

    public static boolean normalize(DataChunk dataChunk) {
        switch (dataChunk.getType()) {
            case Bytes: {
                return HttpRequestURIDecoder.normalizeBytes(dataChunk.getByteChunk());
            }
            case Buffer: {
                return HttpRequestURIDecoder.normalizeBuffer(dataChunk.getBufferChunk());
            }
            case Chars: {
                return HttpRequestURIDecoder.normalizeChars(dataChunk.getCharChunk());
            }
            case String: {
                throw new IllegalStateException("Can't normalize the string representation");
            }
        }
        throw new NullPointerException();
    }

    public static boolean checkNormalize(CharChunk uriCC) {
        int pos;
        char[] c = uriCC.getChars();
        int start = uriCC.getStart();
        int end = uriCC.getEnd();
        for (pos = start; pos < end; ++pos) {
            if (c[pos] == '\\') {
                return false;
            }
            if (c[pos] != '\u0000') continue;
            return false;
        }
        if (COLLAPSE_ADJACENT_SLASHES) {
            for (pos = start; pos < end - 1; ++pos) {
                if (c[pos] != '/' || c[pos + 1] != '/') continue;
                return false;
            }
        }
        if (end - start >= 2 && c[end - 1] == '.' && (c[end - 2] == '/' || c[end - 2] == '.' && c[end - 3] == '/')) {
            return false;
        }
        return uriCC.indexOf("/./", 0, 3, 0) < 0;
    }

    public static boolean normalizeChars(CharChunk uriCC) {
        int pos;
        char[] c = uriCC.getChars();
        int start = uriCC.getStart();
        int end = uriCC.getEnd();
        if (end - start == 1 && c[start] == '*') {
            return true;
        }
        for (pos = start; pos < end; ++pos) {
            if (c[pos] == '\\') {
                return false;
            }
            if (c[pos] != '\u0000') continue;
            return false;
        }
        if (c[start] != '/') {
            return false;
        }
        if (COLLAPSE_ADJACENT_SLASHES) {
            for (pos = start; pos < end - 1; ++pos) {
                if (c[pos] != '/') continue;
                while (pos + 1 < end && c[pos + 1] == '/') {
                    HttpRequestURIDecoder.copyChars(c, pos, pos + 1, end - pos - 1);
                    --end;
                }
            }
        }
        if (end - start > 2 && c[end - 1] == '.' && (c[end - 2] == '/' || c[end - 2] == '.' && c[end - 3] == '/')) {
            c[end] = 47;
            ++end;
        }
        uriCC.setEnd(end);
        int index = 0;
        while ((index = uriCC.indexOf("/./", 0, 3, index)) >= 0) {
            HttpRequestURIDecoder.copyChars(c, start + index, start + index + 2, end - start - index - 2);
            uriCC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriCC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (c[pos] != '/') continue;
                index2 = pos;
            }
            HttpRequestURIDecoder.copyChars(c, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriCC.setEnd(end);
            index = index2;
        }
        uriCC.setChars(c, start, end);
        return true;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        System.arraycopy(b, src, b, dest, len);
    }

    private static void copyChars(char[] c, int dest, int src, int len) {
        System.arraycopy(c, src, c, dest, len);
    }

    protected void log(String message) {
        LOGGER.info(message);
    }

    protected void log(String message, Throwable throwable) {
        LOGGER.log(Level.SEVERE, message, throwable);
    }

    protected void convertMB(MessageBytes mb) {
        if (mb.getType() != 2) {
            return;
        }
        ByteChunk bc = mb.getByteChunk();
        CharChunk cc = mb.getCharChunk();
        cc.allocate(bc.getLength(), -1);
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < bc.getLength(); ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        mb.setChars(cbuf, 0, bc.getLength());
    }

    public static boolean normalizeBytes(ByteChunk bc) {
        int end;
        byte[] bs = bc.getBytes();
        int start = bc.getStart();
        if (start == (end = bc.getEnd())) {
            return false;
        }
        if (end - start == 1 && bs[start] == 42) {
            return true;
        }
        if (end - start > 2 && bs[end - 1] == 46 && (bs[end - 2] == 47 || bs[end - 2] == 46 && bs[end - 3] == 47)) {
            bs[end] = 47;
            ++end;
        }
        int state = 0;
        int srcPos = start;
        int lastSlash = -1;
        int parentSlash = -1;
        for (int pos = start; pos < end; ++pos) {
            if (bs[pos] == 0) {
                return false;
            }
            if (bs[pos] == 92) {
                return false;
            }
            if (bs[pos] == 47) {
                if (state == 0) {
                    state = 1;
                    bs[srcPos] = bs[pos];
                    parentSlash = lastSlash;
                    lastSlash = srcPos++;
                    continue;
                }
                if (state == 1) {
                    if (COLLAPSE_ADJACENT_SLASHES) continue;
                    ++srcPos;
                    continue;
                }
                if (state == 3) {
                    --srcPos;
                    continue;
                }
                if (state != 4) continue;
                if (parentSlash == -1) {
                    return false;
                }
                lastSlash = parentSlash;
                srcPos = parentSlash;
                parentSlash = -1;
                for (int i = lastSlash - 1; i >= start; --i) {
                    if (bs[i] != 47) continue;
                    parentSlash = i;
                    break;
                }
                state = 1;
                bs[srcPos++] = bs[pos];
                continue;
            }
            if (bs[pos] == 46) {
                if (state == 0) {
                    bs[srcPos++] = bs[pos];
                    continue;
                }
                if (state == 1) {
                    state = 3;
                    bs[srcPos++] = bs[pos];
                    continue;
                }
                if (state != 3) continue;
                state = 4;
                bs[srcPos++] = bs[pos];
                continue;
            }
            state = 0;
            bs[srcPos++] = bs[pos];
        }
        bc.setEnd(srcPos);
        return true;
    }

    public static boolean normalizeBuffer(BufferChunk bc) {
        byte b;
        int end;
        Buffer bs = bc.getBuffer();
        int start = bc.getStart();
        if (start == (end = bc.getEnd())) {
            return false;
        }
        if (end - start == 1 && bs.get(start) == 42) {
            return true;
        }
        if (end - start > 2 && bs.get(end - 1) == 46 && ((b = bs.get(end - 2)) == 47 || b == 46 && bs.get(end - 3) == 47)) {
            bs.put(end, (byte)47);
            ++end;
        }
        int state = 0;
        int srcPos = start;
        int lastSlash = -1;
        int parentSlash = -1;
        for (int pos = start; pos < end; ++pos) {
            byte b2 = bs.get(pos);
            if (b2 == 0) {
                return false;
            }
            if (b2 == 92) {
                return false;
            }
            if (b2 == 47) {
                if (state == 0) {
                    state = 1;
                    bs.put(srcPos, b2);
                    parentSlash = lastSlash;
                    lastSlash = srcPos++;
                    continue;
                }
                if (state == 1) {
                    if (COLLAPSE_ADJACENT_SLASHES) continue;
                    ++srcPos;
                    continue;
                }
                if (state == 3) {
                    --srcPos;
                    continue;
                }
                if (state != 4) continue;
                if (parentSlash == -1) {
                    return false;
                }
                lastSlash = parentSlash;
                srcPos = parentSlash;
                parentSlash = -1;
                for (int i = lastSlash - 1; i >= start; --i) {
                    if (bs.get(i) != 47) continue;
                    parentSlash = i;
                    break;
                }
                state = 1;
                bs.put(srcPos++, b2);
                continue;
            }
            if (b2 == 46) {
                if (state == 0) {
                    bs.put(srcPos++, b2);
                    continue;
                }
                if (state == 1) {
                    state = 3;
                    bs.put(srcPos++, b2);
                    continue;
                }
                if (state != 3) continue;
                state = 4;
                bs.put(srcPos++, b2);
                continue;
            }
            state = 0;
            bs.put(srcPos++, b2);
        }
        bc.setEnd(srcPos);
        return true;
    }
}

