/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.shaded.org.ehcache.core.spi.service.ExecutionService;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind.BatchingLocalHeapWriteBehindQueue;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind.NonBatchingLocalHeapWriteBehindQueue;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind.WriteBehind;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.BulkCacheWritingException;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.WriteBehindConfiguration;

public class StripedWriteBehind<K, V>
implements WriteBehind<K, V> {
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();
    private final List<WriteBehind<K, V>> stripes = new ArrayList<WriteBehind<K, V>>();

    public StripedWriteBehind(ExecutionService executionService, String defaultThreadPool, WriteBehindConfiguration config, CacheLoaderWriter<K, V> cacheLoaderWriter) {
        int writeBehindConcurrency = config.getConcurrency();
        for (int i = 0; i < writeBehindConcurrency; ++i) {
            if (config.getBatchingConfiguration() == null) {
                this.stripes.add(new NonBatchingLocalHeapWriteBehindQueue<K, V>(executionService, defaultThreadPool, config, cacheLoaderWriter));
                continue;
            }
            this.stripes.add(new BatchingLocalHeapWriteBehindQueue<K, V>(executionService, defaultThreadPool, config, cacheLoaderWriter));
        }
    }

    private WriteBehind<K, V> getStripe(Object key) {
        return this.stripes.get(Math.abs(key.hashCode() % this.stripes.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        this.writeLock.lock();
        try {
            for (WriteBehind<K, V> queue : this.stripes) {
                queue.start();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V load(K key) throws Exception {
        V v = null;
        this.readLock.lock();
        try {
            v = this.getStripe(key).load(key);
        }
        finally {
            this.readLock.unlock();
        }
        return v;
    }

    @Override
    public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
        HashMap<K, V> entries = new HashMap<K, V>();
        for (K k : keys) {
            entries.put(k, this.load(k));
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(K key, V value) throws Exception {
        this.readLock.lock();
        try {
            this.getStripe(key).write(key, value);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void writeAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) throws BulkCacheWritingException, Exception {
        for (Map.Entry<K, V> entry : entries) {
            this.write(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(K key) throws Exception {
        this.readLock.lock();
        try {
            this.getStripe(key).delete(key);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void deleteAll(Iterable<? extends K> keys) throws BulkCacheWritingException, Exception {
        for (K k : keys) {
            this.delete(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.writeLock.lock();
        try {
            for (WriteBehind<K, V> queue : this.stripes) {
                queue.stop();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getQueueSize() {
        int size = 0;
        this.readLock.lock();
        try {
            for (WriteBehind<K, V> stripe : this.stripes) {
                size = (int)((long)size + stripe.getQueueSize());
            }
        }
        finally {
            this.readLock.unlock();
        }
        return size;
    }
}

