/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.dns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.shaded.org.xbill.DNS.NXTRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.RRset;
import org.apache.hadoop.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.shaded.org.xbill.DNS.SetResponse;
import org.apache.hadoop.shaded.org.xbill.DNS.Zone;
import org.apache.hadoop.shaded.org.xbill.DNS.ZoneTransferException;
import org.apache.hadoop.shaded.org.xbill.DNS.ZoneTransferIn;

public class SecureableZone
extends Zone {
    private List<Record> records;

    public SecureableZone(ZoneTransferIn xfrin) throws IOException, ZoneTransferException {
        super(xfrin);
    }

    public SecureableZone(Name zone, int dclass, String remote) throws IOException, ZoneTransferException {
        super(zone, dclass, remote);
    }

    public SecureableZone(Name zone, String file) throws IOException {
        super(zone, file);
    }

    public SecureableZone(Name zone, Record[] records) throws IOException {
        super(zone, records);
    }

    public void addRecord(Record r) {
        if (this.records == null) {
            this.records = new ArrayList<Record>();
        }
        super.addRecord(r);
        this.records.add(r);
    }

    public void removeRecord(Record r) {
        if (this.records == null) {
            this.records = new ArrayList<Record>();
        }
        super.removeRecord(r);
        this.records.remove(r);
    }

    public Record getNXTRecord(Record queryRecord, Zone zone) {
        RRset[] rRsets;
        Collections.sort(this.records);
        int index = Collections.binarySearch(this.records, queryRecord, new Comparator<Record>(){

            @Override
            public int compare(Record r1, Record r2) {
                return r1.compareTo((Object)r2);
            }
        });
        if (index >= 0) {
            return null;
        }
        if ((index = -index - 1) >= this.records.size()) {
            index = this.records.size() - 1;
        }
        Record base = this.records.get(index);
        SetResponse sr = zone.findRecords(base.getName(), 255);
        BitSet bitMap = new BitSet();
        bitMap.set(30);
        for (RRset rRset : rRsets = sr.answers()) {
            int typeCode = rRset.getType();
            if (typeCode <= 0 || typeCode >= 128) continue;
            bitMap.set(typeCode);
        }
        return new NXTRecord(base.getName(), 1, zone.getSOA().getMinimum(), queryRecord.getName(), bitMap);
    }
}

