/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.util;

import java.lang.reflect.Constructor;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.nativetask.util.NativeTaskOutput;
import org.apache.hadoop.mapred.nativetask.util.NativeTaskOutputFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class OutputUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OutputUtil.class);
    public static final String NATIVE_TASK_OUTPUT_MANAGER = "nativetask.output.manager";

    public static NativeTaskOutput createNativeTaskOutput(Configuration conf, String id) {
        Class clazz = conf.getClass(NATIVE_TASK_OUTPUT_MANAGER, NativeTaskOutputFiles.class);
        LOG.info("nativetask.output.manager = " + clazz.getName());
        try {
            Constructor ctor = clazz.getConstructor(Configuration.class, String.class);
            ctor.setAccessible(true);
            NativeTaskOutput instance = (NativeTaskOutput)ctor.newInstance(conf, id);
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

