/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.fs.CachingGetSpaceUsed;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.GetSpaceUsed;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.BlockPoolSlice;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDataNodeReconfiguration {
    private static final String DATA_DIR = MiniDFSCluster.getBaseDirectory() + "data";
    private static final InetSocketAddress NN_ADDR = new InetSocketAddress("localhost", 5020);
    private final int NUM_NAME_NODE = 1;
    private final int NUM_DATA_NODE = 10;
    private MiniDFSCluster cluster;
    private static long counter = 0L;

    @Before
    public void Setup() throws IOException {
        this.startDFSCluster(1, 10);
    }

    @After
    public void tearDown() throws Exception {
        File dir;
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        if ((dir = new File(DATA_DIR)).exists()) {
            Assert.assertTrue((String)"Cannot delete data-node dirs", (boolean)FileUtil.fullyDelete((File)dir));
        }
    }

    private void startDFSCluster(int numNameNodes, int numDataNodes) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.datanode.peer.stats.enabled", true);
        MiniDFSNNTopology nnTopology = MiniDFSNNTopology.simpleFederatedTopology(numNameNodes);
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(nnTopology).numDataNodes(numDataNodes).build();
        this.cluster.waitActive();
    }

    public DataNode[] createDNsForTest(int numDateNode) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.datanode.data.dir", DATA_DIR);
        conf.set("dfs.datanode.address", "0.0.0.0:0");
        conf.set("dfs.datanode.http.address", "0.0.0.0:0");
        conf.set("dfs.datanode.ipc.address", "0.0.0.0:0");
        conf.setInt("ipc.client.connect.max.retries", 0);
        DataNode[] result = new DataNode[numDateNode];
        for (int i = 0; i < numDateNode; ++i) {
            result[i] = InternalDataNodeTestUtils.startDNWithMockNN((Configuration)conf, NN_ADDR, DATA_DIR);
        }
        return result;
    }

    @Test
    public void testMaxConcurrentMoversReconfiguration() throws ReconfigurationException, IOException {
        int maxConcurrentMovers = 10;
        for (int i = 0; i < 10; ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            try {
                dn.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", "text");
                Assert.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assert.assertTrue((String)"expecting NumberFormatException", (boolean)(expected.getCause() instanceof NumberFormatException));
            }
            try {
                dn.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", String.valueOf(-1));
                Assert.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assert.assertTrue((String)"expecting IllegalArgumentException", (boolean)(expected.getCause() instanceof IllegalArgumentException));
            }
            try {
                dn.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", String.valueOf(0));
                Assert.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assert.assertTrue((String)"expecting IllegalArgumentException", (boolean)(expected.getCause() instanceof IllegalArgumentException));
            }
            dn.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", String.valueOf(maxConcurrentMovers));
            Assert.assertEquals((String)String.format("%s has wrong value", "dfs.datanode.balance.max.concurrent.moves"), (long)maxConcurrentMovers, (long)dn.xserver.balanceThrottler.getMaxConcurrentMovers());
            Assert.assertEquals((String)String.format("%s has wrong value", "dfs.datanode.balance.max.concurrent.moves"), (long)maxConcurrentMovers, (long)Integer.parseInt(dn.getConf().get("dfs.datanode.balance.max.concurrent.moves")));
            dn.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", null);
            Assert.assertEquals((String)String.format("%s has wrong value", "dfs.datanode.balance.max.concurrent.moves"), (long)100L, (long)dn.xserver.balanceThrottler.getMaxConcurrentMovers());
            Assert.assertEquals((String)String.format("expect %s is not configured", "dfs.datanode.balance.max.concurrent.moves"), null, (Object)dn.getConf().get("dfs.datanode.balance.max.concurrent.moves"));
        }
    }

    @Test
    public void testAcquireWithMaxConcurrentMoversGreaterThanDefault() throws IOException, ReconfigurationException {
        DataNode[] dns = this.createDNsForTest(1);
        try {
            this.testAcquireOnMaxConcurrentMoversReconfiguration(dns[0], 10);
        }
        finally {
            dns[0].shutdown();
        }
    }

    @Test
    public void testAcquireWithMaxConcurrentMoversLessThanDefault() throws IOException, ReconfigurationException {
        DataNode[] dns = this.createDNsForTest(1);
        try {
            this.testAcquireOnMaxConcurrentMoversReconfiguration(dns[0], 3);
        }
        finally {
            dns[0].shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedDecreaseConcurrentMovers() throws IOException, ReconfigurationException {
        DataNode[] dns = this.createDNsForTest(1);
        DataNode dataNode = dns[0];
        try {
            dataNode.xserver.updateBalancerMaxConcurrentMovers(2);
            dataNode.xserver.balanceThrottler.acquire();
            dataNode.xserver.balanceThrottler.acquire();
            dataNode.xserver.setMaxReconfigureWaitTime(1);
            boolean success = dataNode.xserver.updateBalancerMaxConcurrentMovers(1);
            Assert.assertFalse((boolean)success);
        }
        finally {
            dataNode.shutdown();
        }
    }

    @Test(expected=ReconfigurationException.class)
    public void testFailedDecreaseConcurrentMoversReconfiguration() throws IOException, ReconfigurationException {
        DataNode[] dns = this.createDNsForTest(1);
        DataNode dataNode = dns[0];
        try {
            dataNode.xserver.updateBalancerMaxConcurrentMovers(2);
            dataNode.xserver.balanceThrottler.acquire();
            dataNode.xserver.balanceThrottler.acquire();
            dataNode.xserver.setMaxReconfigureWaitTime(1);
            dataNode.reconfigurePropertyImpl("dfs.datanode.balance.max.concurrent.moves", "1");
        }
        catch (ReconfigurationException e) {
            Assert.assertEquals((Object)"dfs.datanode.balance.max.concurrent.moves", (Object)e.getProperty());
            Assert.assertEquals((Object)"1", (Object)e.getNewValue());
            throw e;
        }
        finally {
            dataNode.shutdown();
        }
    }

    private void testAcquireOnMaxConcurrentMoversReconfiguration(DataNode dataNode, int maxConcurrentMovers) throws IOException, ReconfigurationException {
        int i;
        int defaultMaxThreads = dataNode.getConf().getInt("dfs.datanode.balance.max.concurrent.moves", 100);
        for (i = 0; i < defaultMaxThreads; ++i) {
            Assert.assertEquals((String)"should be able to get thread quota", (Object)true, (Object)dataNode.xserver.balanceThrottler.acquire());
        }
        Assert.assertEquals((String)"should not be able to get thread quota", (Object)false, (Object)dataNode.xserver.balanceThrottler.acquire());
        for (i = 0; i < defaultMaxThreads; ++i) {
            dataNode.xserver.balanceThrottler.release();
        }
        dataNode.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", String.valueOf(maxConcurrentMovers));
        Assert.assertEquals((String)"thread quota is wrong", (long)maxConcurrentMovers, (long)dataNode.xserver.balanceThrottler.getMaxConcurrentMovers());
        for (i = 0; i < maxConcurrentMovers; ++i) {
            Assert.assertEquals((String)"should be able to get thread quota", (Object)true, (Object)dataNode.xserver.balanceThrottler.acquire());
        }
        Assert.assertEquals((String)"should not be able to get thread quota", (Object)false, (Object)dataNode.xserver.balanceThrottler.acquire());
    }

    @Test
    public void testBlockReportIntervalReconfiguration() throws ReconfigurationException {
        int blockReportInterval = 300000;
        String[] blockReportParameters = new String[]{"dfs.blockreport.intervalMsec", "dfs.blockreport.split.threshold", "dfs.blockreport.initialDelay"};
        for (int i = 0; i < 10; ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            BlockPoolManager blockPoolManager = dn.getBlockPoolManager();
            for (String blockReportParameter : blockReportParameters) {
                try {
                    dn.reconfigureProperty(blockReportParameter, "text");
                    Assert.fail((String)"ReconfigurationException expected");
                }
                catch (ReconfigurationException expected) {
                    Assert.assertTrue((String)"expecting NumberFormatException", (boolean)(expected.getCause() instanceof NumberFormatException));
                }
            }
            try {
                dn.reconfigureProperty("dfs.blockreport.intervalMsec", String.valueOf(-1));
                Assert.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assert.assertTrue((String)"expecting IllegalArgumentException", (boolean)(expected.getCause() instanceof IllegalArgumentException));
            }
            try {
                dn.reconfigureProperty("dfs.blockreport.split.threshold", String.valueOf(-1));
                Assert.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assert.assertTrue((String)"expecting IllegalArgumentException", (boolean)(expected.getCause() instanceof IllegalArgumentException));
            }
            dn.reconfigureProperty("dfs.blockreport.initialDelay", String.valueOf(-1));
            Assert.assertEquals((long)0L, (long)dn.getDnConf().initialBlockReportDelayMs);
            dn.reconfigureProperty("dfs.blockreport.intervalMsec", String.valueOf(blockReportInterval));
            for (BPOfferService bpos : blockPoolManager.getAllNamenodeThreads()) {
                if (bpos == null) continue;
                for (BPServiceActor actor : bpos.getBPServiceActors()) {
                    Assert.assertEquals((String)String.format("%s has wrong value", "dfs.blockreport.intervalMsec"), (long)blockReportInterval, (long)actor.getScheduler().getBlockReportIntervalMs());
                }
            }
            dn.reconfigureProperty("dfs.blockreport.split.threshold", String.valueOf(123));
            Assert.assertEquals((long)123L, (long)dn.getDnConf().blockReportSplitThreshold);
            dn.reconfigureProperty("dfs.blockreport.initialDelay", "123");
            Assert.assertEquals((long)123000L, (long)dn.getDnConf().initialBlockReportDelayMs);
            dn.reconfigureProperty("dfs.blockreport.intervalMsec", null);
            for (BPOfferService bpos : blockPoolManager.getAllNamenodeThreads()) {
                if (bpos == null) continue;
                for (BPServiceActor actor : bpos.getBPServiceActors()) {
                    Assert.assertEquals((String)String.format("%s has wrong value", "dfs.blockreport.intervalMsec"), (long)21600000L, (long)actor.getScheduler().getBlockReportIntervalMs());
                }
            }
            Assert.assertNull((String)String.format("expect %s is not configured", "dfs.blockreport.intervalMsec"), (Object)dn.getConf().get("dfs.blockreport.intervalMsec"));
            dn.reconfigureProperty("dfs.blockreport.split.threshold", null);
            Assert.assertNull((String)String.format("expect %s is not configured", "dfs.blockreport.split.threshold"), (Object)dn.getConf().get("dfs.blockreport.split.threshold"));
            dn.reconfigureProperty("dfs.blockreport.initialDelay", null);
            Assert.assertNull((String)String.format("expect %s is not configured", "dfs.blockreport.initialDelay"), (Object)dn.getConf().get("dfs.blockreport.initialDelay"));
        }
    }

    @Test
    public void testDataXceiverReconfiguration() throws ReconfigurationException {
        for (int i = 0; i < 10; ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            try {
                dn.reconfigureProperty("dfs.datanode.max.transfer.threads", "text");
                Assert.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assert.assertTrue((String)"expecting NumberFormatException", (boolean)(expected.getCause() instanceof NumberFormatException));
            }
            try {
                dn.reconfigureProperty("dfs.datanode.max.transfer.threads", String.valueOf(-1));
                Assert.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assert.assertTrue((String)"expecting IllegalArgumentException", (boolean)(expected.getCause() instanceof IllegalArgumentException));
            }
            dn.reconfigureProperty("dfs.datanode.max.transfer.threads", String.valueOf(123));
            Assert.assertEquals((String)String.format("%s has wrong value", "dfs.datanode.max.transfer.threads"), (long)123L, (long)dn.getXferServer().getMaxXceiverCount());
            dn.reconfigureProperty("dfs.datanode.max.transfer.threads", null);
            Assert.assertEquals((String)String.format("%s has wrong value", "dfs.datanode.max.transfer.threads"), (long)4096L, (long)dn.getXferServer().getMaxXceiverCount());
            Assert.assertNull((String)String.format("expect %s is not configured", "dfs.datanode.max.transfer.threads"), (Object)dn.getConf().get("dfs.datanode.max.transfer.threads"));
        }
    }

    @Test
    public void testCacheReportReconfiguration() throws ReconfigurationException {
        int cacheReportInterval = 300000;
        for (int i = 0; i < 10; ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            try {
                dn.reconfigureProperty("dfs.cachereport.intervalMsec", "text");
                Assert.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assert.assertTrue((String)"expecting NumberFormatException", (boolean)(expected.getCause() instanceof NumberFormatException));
            }
            try {
                dn.reconfigureProperty("dfs.cachereport.intervalMsec", String.valueOf(-1));
                Assert.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assert.assertTrue((String)"expecting IllegalArgumentException", (boolean)(expected.getCause() instanceof IllegalArgumentException));
            }
            dn.reconfigureProperty("dfs.cachereport.intervalMsec", String.valueOf(cacheReportInterval));
            Assert.assertEquals((String)String.format("%s has wrong value", "dfs.cachereport.intervalMsec"), (long)cacheReportInterval, (long)dn.getDnConf().getCacheReportInterval());
            dn.reconfigureProperty("dfs.cachereport.intervalMsec", null);
            Assert.assertEquals((String)String.format("%s has wrong value", "dfs.cachereport.intervalMsec"), (long)10000L, (long)dn.getDnConf().getCacheReportInterval());
            Assert.assertNull((String)String.format("expect %s is not configured", "dfs.cachereport.intervalMsec"), (Object)dn.getConf().get("dfs.cachereport.intervalMsec"));
        }
    }

    @Test
    public void testSlowPeerParameters() throws Exception {
        String[] slowPeersParameters = new String[]{"dfs.datanode.min.outlier.detection.nodes", "dfs.datanode.slowpeer.low.threshold.ms", "dfs.datanode.peer.metrics.min.outlier.detection.samples"};
        for (int i = 0; i < 10; ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            LambdaTestUtils.intercept(ReconfigurationException.class, (String)"Could not change property dfs.datanode.peer.stats.enabled from 'true' to 'text'", () -> dn.reconfigureProperty("dfs.datanode.peer.stats.enabled", "text"));
            for (String parameter : slowPeersParameters) {
                try {
                    dn.reconfigureProperty(parameter, "text");
                    Assert.fail((String)"ReconfigurationException expected");
                }
                catch (ReconfigurationException expected) {
                    Assert.assertTrue((String)"expecting NumberFormatException", (boolean)(expected.getCause() instanceof NumberFormatException));
                }
                try {
                    dn.reconfigureProperty(parameter, String.valueOf(-1));
                    Assert.fail((String)"ReconfigurationException expected");
                }
                catch (ReconfigurationException expected) {
                    Assert.assertTrue((String)"expecting IllegalArgumentException", (boolean)(expected.getCause() instanceof IllegalArgumentException));
                }
            }
            dn.reconfigureProperty("dfs.datanode.peer.stats.enabled", "false");
            Assert.assertFalse((boolean)dn.getDnConf().peerStatsEnabled);
            dn.reconfigureProperty("dfs.datanode.peer.stats.enabled", "true");
            for (String parameter : slowPeersParameters) {
                dn.reconfigureProperty(parameter, "123");
            }
            Assert.assertEquals((long)123L, (long)dn.getPeerMetrics().getMinOutlierDetectionNodes());
            Assert.assertEquals((long)123L, (long)dn.getPeerMetrics().getLowThresholdMs());
            Assert.assertEquals((long)123L, (long)dn.getPeerMetrics().getMinOutlierDetectionSamples());
            Assert.assertEquals((long)123L, (long)dn.getPeerMetrics().getSlowNodeDetector().getMinOutlierDetectionNodes());
            Assert.assertEquals((long)123L, (long)dn.getPeerMetrics().getSlowNodeDetector().getLowThresholdMs());
            dn.reconfigureProperty("dfs.datanode.peer.stats.enabled", null);
            Assert.assertEquals((String)String.format("expect %s is not configured", "dfs.datanode.peer.stats.enabled"), null, (Object)dn.getConf().get("dfs.datanode.peer.stats.enabled"));
            dn.reconfigureProperty("dfs.datanode.peer.stats.enabled", "true");
            for (String parameter : slowPeersParameters) {
                dn.reconfigureProperty(parameter, null);
            }
            Assert.assertEquals((String)String.format("expect %s is not configured", "dfs.datanode.min.outlier.detection.nodes"), null, (Object)dn.getConf().get("dfs.datanode.min.outlier.detection.nodes"));
            Assert.assertEquals((String)String.format("expect %s is not configured", "dfs.datanode.slowpeer.low.threshold.ms"), null, (Object)dn.getConf().get("dfs.datanode.slowpeer.low.threshold.ms"));
            Assert.assertEquals((String)String.format("expect %s is not configured", "dfs.datanode.peer.metrics.min.outlier.detection.samples"), null, (Object)dn.getConf().get("dfs.datanode.peer.metrics.min.outlier.detection.samples"));
            Assert.assertEquals((long)dn.getPeerMetrics().getSlowNodeDetector().getMinOutlierDetectionNodes(), (long)10L);
            Assert.assertEquals((long)dn.getPeerMetrics().getSlowNodeDetector().getLowThresholdMs(), (long)5L);
        }
    }

    @Test
    public void testSlowDiskParameters() throws ReconfigurationException, IOException {
        String[] slowDisksParameters1 = new String[]{"dfs.datanode.min.outlier.detection.disks", "dfs.datanode.slowdisk.low.threshold.ms"};
        for (int i = 0; i < 10; ++i) {
            String[] slowDisksParameters2;
            DataNode dn = this.cluster.getDataNodes().get(i);
            try {
                dn.reconfigureProperty("dfs.datanode.outliers.report.interval", "text");
            }
            catch (ReconfigurationException expected) {
                Assert.assertTrue((String)"expecting NumberFormatException", (boolean)(expected.getCause() instanceof NumberFormatException));
            }
            try {
                dn.reconfigureProperty("dfs.datanode.fileio.profiling.sampling.percentage", "text");
            }
            catch (ReconfigurationException expected) {
                Assert.assertTrue((String)"expecting NumberFormatException", (boolean)(expected.getCause() instanceof NumberFormatException));
            }
            dn.reconfigureProperty("dfs.datanode.fileio.profiling.sampling.percentage", "1");
            for (String parameter : slowDisksParameters1) {
                try {
                    dn.reconfigureProperty(parameter, "text");
                    Assert.fail((String)"ReconfigurationException expected");
                }
                catch (ReconfigurationException expected) {
                    Assert.assertTrue((String)"expecting NumberFormatException", (boolean)(expected.getCause() instanceof NumberFormatException));
                }
                try {
                    dn.reconfigureProperty(parameter, String.valueOf(-1));
                    Assert.fail((String)"ReconfigurationException expected");
                }
                catch (ReconfigurationException expected) {
                    Assert.assertTrue((String)"expecting IllegalArgumentException", (boolean)(expected.getCause() instanceof IllegalArgumentException));
                }
            }
            dn.reconfigureProperty("dfs.datanode.outliers.report.interval", "1ms");
            Assert.assertEquals((long)1L, (long)dn.getDnConf().outliersReportIntervalMs);
            BlockPoolManager blockPoolManager = new BlockPoolManager(dn);
            blockPoolManager.refreshNamenodes(dn.getConf());
            for (BPOfferService bpos : blockPoolManager.getAllNamenodeThreads()) {
                if (bpos == null) continue;
                for (BPServiceActor actor : bpos.getBPServiceActors()) {
                    Assert.assertEquals((String)String.format("%s has wrong value", "dfs.datanode.outliers.report.interval"), (long)1L, (long)actor.getScheduler().getOutliersReportIntervalMs());
                }
            }
            for (String parameter : slowDisksParameters2 = new String[]{"dfs.datanode.fileio.profiling.sampling.percentage", "dfs.datanode.min.outlier.detection.disks", "dfs.datanode.slowdisk.low.threshold.ms"}) {
                dn.reconfigureProperty(parameter, "99");
            }
            Assert.assertEquals((long)99L, (long)dn.getDiskMetrics().getMinOutlierDetectionDisks());
            Assert.assertEquals((long)99L, (long)dn.getDiskMetrics().getLowThresholdMs());
            Assert.assertTrue((boolean)dn.getDnConf().diskStatsEnabled);
            Assert.assertTrue((boolean)dn.getFileIoProvider().getProfilingEventHook().getDiskStatsEnabled());
            Assert.assertEquals((long)2126008810L, (long)dn.getFileIoProvider().getProfilingEventHook().getSampleRangeMax());
            Assert.assertEquals((long)99L, (long)dn.getDiskMetrics().getSlowDiskDetector().getMinOutlierDetectionNodes());
            Assert.assertEquals((long)99L, (long)dn.getDiskMetrics().getSlowDiskDetector().getLowThresholdMs());
            dn.reconfigureProperty("dfs.datanode.outliers.report.interval", null);
            Assert.assertEquals((String)String.format("expect %s is not configured", "dfs.datanode.outliers.report.interval"), null, (Object)dn.getConf().get("dfs.datanode.outliers.report.interval"));
            dn.reconfigureProperty("dfs.datanode.fileio.profiling.sampling.percentage", null);
            Assert.assertEquals((String)String.format("expect %s is not configured", "dfs.datanode.fileio.profiling.sampling.percentage"), null, (Object)dn.getConf().get("dfs.datanode.fileio.profiling.sampling.percentage"));
            Assert.assertFalse((boolean)dn.getFileIoProvider().getProfilingEventHook().getDiskStatsEnabled());
            Assert.assertEquals((long)0L, (long)dn.getFileIoProvider().getProfilingEventHook().getSampleRangeMax());
            dn.reconfigureProperty("dfs.datanode.fileio.profiling.sampling.percentage", "1");
            dn.reconfigureProperty("dfs.datanode.min.outlier.detection.disks", null);
            dn.reconfigureProperty("dfs.datanode.slowdisk.low.threshold.ms", null);
            Assert.assertEquals((String)String.format("expect %s is not configured", "dfs.datanode.min.outlier.detection.disks"), null, (Object)dn.getConf().get("dfs.datanode.min.outlier.detection.disks"));
            Assert.assertEquals((String)String.format("expect %s is not configured", "dfs.datanode.slowdisk.low.threshold.ms"), null, (Object)dn.getConf().get("dfs.datanode.slowdisk.low.threshold.ms"));
            Assert.assertEquals((long)5L, (long)dn.getDiskMetrics().getSlowDiskDetector().getMinOutlierDetectionNodes());
            Assert.assertEquals((long)20L, (long)dn.getDiskMetrics().getSlowDiskDetector().getLowThresholdMs());
        }
    }

    @Test
    public void testDfsUsageParameters() throws ReconfigurationException {
        String[] dfsUsageParameters = new String[]{"fs.du.interval", "fs.getspaceused.jitterMillis"};
        for (int i = 0; i < 10; ++i) {
            GetSpaceUsed dfsUsage;
            DataNode dn = this.cluster.getDataNodes().get(i);
            for (String parameter : dfsUsageParameters) {
                try {
                    dn.reconfigureProperty(parameter, "text");
                    Assert.fail((String)"ReconfigurationException expected");
                }
                catch (ReconfigurationException expected) {
                    Assert.assertTrue((String)"expecting NumberFormatException", (boolean)(expected.getCause() instanceof NumberFormatException));
                }
                try {
                    dn.reconfigureProperty(parameter, String.valueOf(-1));
                    Assert.fail((String)"ReconfigurationException expected");
                }
                catch (ReconfigurationException expected) {
                    Assert.assertTrue((String)"expecting IllegalArgumentException", (boolean)(expected.getCause() instanceof IllegalArgumentException));
                }
            }
            for (String parameter : dfsUsageParameters) {
                dn.reconfigureProperty(parameter, "99");
            }
            List volumeList = dn.data.getVolumeList();
            for (FsVolumeImpl fsVolume : volumeList) {
                Map blockPoolSlices = fsVolume.getBlockPoolSlices();
                for (Map.Entry entry : blockPoolSlices.entrySet()) {
                    dfsUsage = ((BlockPoolSlice)entry.getValue()).getDfsUsage();
                    if (!(dfsUsage instanceof CachingGetSpaceUsed)) continue;
                    Assert.assertEquals((long)99L, (long)((CachingGetSpaceUsed)((BlockPoolSlice)entry.getValue()).getDfsUsage()).getRefreshInterval());
                    Assert.assertEquals((long)99L, (long)((CachingGetSpaceUsed)((BlockPoolSlice)entry.getValue()).getDfsUsage()).getJitter());
                }
            }
            for (String parameter : dfsUsageParameters) {
                dn.reconfigureProperty(parameter, null);
            }
            for (FsVolumeImpl fsVolume : volumeList) {
                Map blockPoolSlices = fsVolume.getBlockPoolSlices();
                for (Map.Entry entry : blockPoolSlices.entrySet()) {
                    dfsUsage = ((BlockPoolSlice)entry.getValue()).getDfsUsage();
                    if (dfsUsage instanceof CachingGetSpaceUsed) {
                        Assert.assertEquals((String)String.format("expect %s is not configured", "fs.du.interval"), (long)600000L, (long)((CachingGetSpaceUsed)((BlockPoolSlice)entry.getValue()).getDfsUsage()).getRefreshInterval());
                        Assert.assertEquals((String)String.format("expect %s is not configured", "fs.getspaceused.jitterMillis"), (long)60000L, (long)((CachingGetSpaceUsed)((BlockPoolSlice)entry.getValue()).getDfsUsage()).getJitter());
                    }
                    Assert.assertEquals((String)String.format("expect %s is not configured", "fs.du.interval"), null, (Object)dn.getConf().get("fs.du.interval"));
                    Assert.assertEquals((String)String.format("expect %s is not configured", "fs.getspaceused.jitterMillis"), null, (Object)dn.getConf().get("fs.getspaceused.jitterMillis"));
                }
            }
        }
    }

    @Test
    public void testDfsUsageKlass() throws ReconfigurationException, InterruptedException {
        long lastCounter = counter;
        Thread.sleep(5000L);
        Assert.assertEquals((long)lastCounter, (long)counter);
        for (int i = 0; i < 10; ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            dn.reconfigurePropertyImpl("fs.getspaceused.classname", DummyCachingGetSpaceUsed.class.getName());
        }
        lastCounter = counter;
        Thread.sleep(5000L);
        Assert.assertTrue((counter > lastCounter ? 1 : 0) != 0);
    }

    public static class DummyCachingGetSpaceUsed
    extends CachingGetSpaceUsed {
        public DummyCachingGetSpaceUsed(GetSpaceUsed.Builder builder) throws IOException {
            super(builder.setInterval(1000L).setJitter(Long.valueOf(0L)));
        }

        protected void refresh() {
            counter++;
        }
    }
}

