/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.lang;

import java.util.concurrent.Callable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.lib.util.Check;

@InterfaceAudience.Private
public class RunnableCallable
implements Callable<Void>,
Runnable {
    private Runnable runnable;
    private Callable<?> callable;

    public RunnableCallable(Runnable runnable) {
        this.runnable = Check.notNull(runnable, "runnable");
    }

    public RunnableCallable(Callable<?> callable) {
        this.callable = Check.notNull(callable, "callable");
    }

    @Override
    public Void call() throws Exception {
        if (this.runnable != null) {
            this.runnable.run();
        } else {
            this.callable.call();
        }
        return null;
    }

    @Override
    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        } else {
            try {
                this.callable.call();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public String toString() {
        return this.runnable != null ? this.runnable.getClass().getSimpleName() : this.callable.getClass().getSimpleName();
    }
}

