/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.servlet.UriPatternMatcher;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum UriPatternType {
    SERVLET,
    REGEX;


    static UriPatternMatcher get(UriPatternType type, String pattern) {
        switch (type) {
            case SERVLET: {
                return new ServletStyleUriPatternMatcher(pattern);
            }
            case REGEX: {
                return new RegexUriPatternMatcher(pattern);
            }
        }
        return null;
    }

    private static String getUri(String uri) {
        int queryIdx = uri.indexOf(63);
        if (queryIdx != -1) {
            uri = uri.substring(0, queryIdx);
        }
        return uri;
    }

    private static class RegexUriPatternMatcher
    implements UriPatternMatcher {
        private final Pattern pattern;

        public RegexUriPatternMatcher(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        @Override
        public boolean matches(String uri) {
            return null != uri && this.pattern.matcher(UriPatternType.getUri(uri)).matches();
        }

        @Override
        public String extractPath(String path) {
            int end;
            Matcher matcher = this.pattern.matcher(path);
            if (matcher.matches() && matcher.groupCount() >= 1 && (end = matcher.start(1)) < path.length()) {
                return path.substring(0, end);
            }
            return null;
        }

        @Override
        public UriPatternType getPatternType() {
            return REGEX;
        }
    }

    private static class ServletStyleUriPatternMatcher
    implements UriPatternMatcher {
        private final String pattern;
        private final Kind patternKind;

        public ServletStyleUriPatternMatcher(String pattern) {
            if (pattern.startsWith("*")) {
                this.pattern = pattern.substring(1);
                this.patternKind = Kind.PREFIX;
            } else if (pattern.endsWith("*")) {
                this.pattern = pattern.substring(0, pattern.length() - 1);
                this.patternKind = Kind.SUFFIX;
            } else {
                this.pattern = pattern;
                this.patternKind = Kind.LITERAL;
            }
        }

        @Override
        public boolean matches(String uri) {
            if (null == uri) {
                return false;
            }
            uri = UriPatternType.getUri(uri);
            if (this.patternKind == Kind.PREFIX) {
                return uri.endsWith(this.pattern);
            }
            if (this.patternKind == Kind.SUFFIX) {
                return uri.startsWith(this.pattern);
            }
            return this.pattern.equals(uri);
        }

        @Override
        public String extractPath(String path) {
            if (this.patternKind == Kind.PREFIX) {
                return null;
            }
            if (this.patternKind == Kind.SUFFIX) {
                String extract = this.pattern;
                if (extract.endsWith("/")) {
                    extract = extract.substring(0, extract.length() - 1);
                }
                return extract;
            }
            return path;
        }

        @Override
        public UriPatternType getPatternType() {
            return SERVLET;
        }

        private static enum Kind {
            PREFIX,
            SUFFIX,
            LITERAL;

        }
    }
}

