/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.component;

import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.component.ComponentRestartPolicy;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;

public final class NeverRestartPolicy
implements ComponentRestartPolicy {
    private static NeverRestartPolicy INSTANCE = new NeverRestartPolicy();

    private NeverRestartPolicy() {
    }

    public static NeverRestartPolicy getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isLongLived() {
        return false;
    }

    @Override
    public boolean hasCompleted(Component component) {
        return component.getNumSucceededInstances() + component.getNumFailedInstances() >= (long)component.getNumDesiredInstances();
    }

    @Override
    public boolean hasCompletedSuccessfully(Component component) {
        return component.getNumSucceededInstances() == (long)component.getNumDesiredInstances();
    }

    @Override
    public boolean shouldRelaunchInstance(ComponentInstance componentInstance, ContainerStatus containerStatus) {
        return false;
    }

    @Override
    public boolean isReadyForDownStream(Component dependentComponent) {
        return (long)dependentComponent.getNumReadyInstances() + dependentComponent.getNumSucceededInstances() + dependentComponent.getNumFailedInstances() >= (long)dependentComponent.getNumDesiredInstances();
    }

    @Override
    public boolean allowUpgrades() {
        return false;
    }

    @Override
    public boolean shouldTerminate(Component component) {
        long nFailed;
        long nSucceeded = component.getNumSucceededInstances();
        return nSucceeded + (nFailed = component.getNumFailedInstances()) >= component.getComponentSpec().getNumberOfContainers();
    }

    @Override
    public boolean allowContainerRetriesForInstance(ComponentInstance componentInstance) {
        return false;
    }
}

