/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import rx.Observer;
import rx.observables.SyncOnSubscribe;

public final class OnSubscribeInputStream
extends SyncOnSubscribe<InputStream, byte[]> {
    private final InputStream is;
    private final int size;

    public OnSubscribeInputStream(InputStream is, int size) {
        this.is = is;
        this.size = size;
    }

    protected InputStream generateState() {
        return this.is;
    }

    protected InputStream next(InputStream is, Observer<? super byte[]> observer) {
        byte[] buffer = new byte[this.size];
        try {
            int count = is.read(buffer);
            if (count == -1) {
                observer.onCompleted();
            } else if (count < this.size) {
                observer.onNext((Object)Arrays.copyOf(buffer, count));
            } else {
                observer.onNext((Object)buffer);
            }
        }
        catch (IOException e) {
            observer.onError((Throwable)e);
        }
        return is;
    }
}

