/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer.blockgenerator;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.tools.dynamometer.blockgenerator.BlockInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateDNBlockInfosReducer
extends Reducer<IntWritable, BlockInfo, NullWritable, Text> {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateDNBlockInfosReducer.class);
    private MultipleOutputs<NullWritable, Text> multiOutputs;

    public void setup(Reducer.Context context) {
        this.multiOutputs = new MultipleOutputs((TaskInputOutputContext)context);
    }

    public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        this.multiOutputs.close();
        this.multiOutputs = null;
    }

    public void reduce(IntWritable key, Iterable<BlockInfo> values, Reducer.Context context) throws IOException, InterruptedException {
        long blockIndex = 0L;
        int datanodeId = key.get();
        String dnFile = "dn" + datanodeId + "-a-" + context.getTaskAttemptID().getId();
        Iterator<BlockInfo> it = values.iterator();
        long startTimestamp = System.currentTimeMillis();
        Path baseOutputPath = FileOutputFormat.getOutputPath((JobContext)context);
        String fullPath = new Path(baseOutputPath, dnFile).toString();
        Text out = new Text();
        while (it.hasNext()) {
            BlockInfo blockInfo = it.next();
            String blockLine = blockInfo.getBlockId() + "," + blockInfo.getBlockGenerationStamp() + "," + blockInfo.getSize();
            out.set(blockLine);
            this.multiOutputs.write((Object)NullWritable.get(), (Object)out, fullPath);
            if (++blockIndex % 1000L != 0L) continue;
            context.progress();
            long endTimestamp = System.currentTimeMillis();
            System.out.println("Time taken to process 1000 records in ms:" + (endTimestamp - startTimestamp));
            startTimestamp = endTimestamp;
        }
        LOG.info("Number of blocks processed:" + blockIndex);
    }
}

