/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.stream;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexProgram;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSourceSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.VectorSearchSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.VectorSearchTableSourceSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecVectorSearchTableFunction;
import org.apache.flink.table.planner.plan.nodes.physical.common.CommonPhysicalVectorSearchFunction;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.utils.ChangelogPlanUtils;
import org.apache.flink.table.planner.plan.utils.VectorSearchUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.util.Preconditions;

public class StreamPhysicalVectorSearchTableFunction
extends CommonPhysicalVectorSearchFunction
implements StreamPhysicalRel {
    public StreamPhysicalVectorSearchTableFunction(RelOptCluster cluster, RelTraitSet traits, RelNode input, TableSourceTable searchTable, @Nullable RexProgram projectionOnVectorTable, VectorSearchSpec vectorSearchSpec, RelDataType outputRowType) {
        super(cluster, traits, input, searchTable, projectionOnVectorTable, vectorSearchSpec, outputRowType);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new StreamPhysicalVectorSearchTableFunction(this.getCluster(), traitSet, inputs.get(0), this.searchTable, this.projectionOnVectorTable, this.vectorSearchSpec, this.outputRowType);
    }

    @Override
    public boolean requireWatermark() {
        return false;
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        TableConfig tableConfig = ShortcutUtils.unwrapTableConfig(this);
        VectorSearchTableSourceSpec sourceSpec = new VectorSearchTableSourceSpec(this.searchTable);
        ((DynamicTableSourceSpec)Preconditions.checkNotNull((Object)sourceSpec.getTableSourceSpec())).setTableSource(this.searchTable.tableSource());
        if (this.projectionOnVectorTable != null) {
            throw new UnsupportedOperationException("Don't support calc on VECTOR_SEARCH node now.");
        }
        return new StreamExecVectorSearchTableFunction((ReadableConfig)tableConfig, sourceSpec, this.vectorSearchSpec, VectorSearchUtil.isAsyncVectorSearch(this.searchTable, Optional.ofNullable(this.vectorSearchSpec.getRuntimeConfig()).orElse(Collections.emptyMap()), this.vectorSearchSpec.getSearchColumns().keySet()) ? VectorSearchUtil.getMergedVectorSearchAsyncOptions(this.vectorSearchSpec.getRuntimeConfig() == null ? Collections.emptyMap() : this.vectorSearchSpec.getRuntimeConfig(), tableConfig, this.getInputChangelogMode()) : null, InputProperty.DEFAULT, FlinkTypeFactory.toLogicalRowType(this.outputRowType), this.getRelDetailedDescription());
    }

    private ChangelogMode getInputChangelogMode() {
        return this.getInputChangelogMode(this.getInput());
    }

    private ChangelogMode getInputChangelogMode(RelNode rel) {
        if (rel instanceof StreamPhysicalRel) {
            return JavaScalaConversionUtil.toJava(ChangelogPlanUtils.getChangelogMode((StreamPhysicalRel)rel)).orElse(ChangelogMode.insertOnly());
        }
        if (rel instanceof HepRelVertex) {
            return this.getInputChangelogMode(((HepRelVertex)rel).getCurrentRel());
        }
        return ChangelogMode.insertOnly();
    }
}

