/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.utils.OperationConverterUtils;

public abstract class AbstractCreateTableConverter<T extends SqlCreateTable>
implements SqlNodeConverter<T> {
    protected abstract MergeContext getMergeContext(T var1, SqlNodeConverter.ConvertContext var2);

    protected final Optional<TableDistribution> getDerivedTableDistribution(T sqlCreateTable) {
        return Optional.ofNullable(((SqlCreateTable)sqlCreateTable).getDistribution()).map(OperationConverterUtils::getDistributionFromSqlDistribution);
    }

    protected final List<String> getDerivedPartitionKeys(T sqlCreateTable) {
        return OperationConverterUtils.getColumnNames(((SqlCreateTable)sqlCreateTable).getPartitionKeyList());
    }

    protected final Map<String, String> getDerivedTableOptions(T sqlCreateTable) {
        return OperationConverterUtils.getProperties(((SqlCreateTable)sqlCreateTable).getPropertyList());
    }

    protected final String getComment(T sqlCreateTable) {
        return OperationConverterUtils.getComment(((SqlCreateTable)sqlCreateTable).getComment());
    }

    protected final ResolvedCatalogTable getResolvedCatalogTable(T sqlCreateTable, SqlNodeConverter.ConvertContext context, ResolvedSchema schemaToMerge) {
        MergeContext mergeContext = this.getMergeContext(sqlCreateTable, context);
        List<String> partitionKeys = mergeContext.getMergedPartitionKeys();
        Schema schema = mergeContext.getMergedSchema(schemaToMerge);
        this.verifyPartitioningColumnsExist(schema, partitionKeys);
        Map<String, String> tableOptions = mergeContext.getMergedTableOptions();
        TableDistribution distribution = mergeContext.getMergedTableDistribution().orElse(null);
        String comment = this.getComment(sqlCreateTable);
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(schema).comment(comment).distribution(distribution).options(tableOptions).partitionKeys(partitionKeys).build();
        return context.getCatalogManager().resolveCatalogTable(catalogTable);
    }

    protected final ObjectIdentifier getIdentifier(SqlCreateTable node, SqlNodeConverter.ConvertContext context) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])node.fullTableName());
        return context.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
    }

    protected final CreateTableOperation getCreateTableOperation(ObjectIdentifier identifier, ResolvedCatalogTable tableWithResolvedSchema, T sqlCreateTable) {
        return new CreateTableOperation(identifier, tableWithResolvedSchema, ((SqlCreateTable)sqlCreateTable).isIfNotExists(), ((SqlCreateTable)sqlCreateTable).isTemporary());
    }

    private void verifyPartitioningColumnsExist(Schema schema, List<String> partitionKeys) {
        Set columnNames = schema.getColumns().stream().map(Schema.UnresolvedColumn::getName).collect(Collectors.toCollection(LinkedHashSet::new));
        for (String partitionKey : partitionKeys) {
            if (columnNames.contains(partitionKey)) continue;
            throw new ValidationException(String.format("Partition column '%s' not defined in the table schema. Available columns: [%s]", partitionKey, columnNames.stream().collect(Collectors.joining("', '", "'", "'"))));
        }
    }

    protected static interface MergeContext {
        public Schema getMergedSchema(ResolvedSchema var1);

        public Map<String, String> getMergedTableOptions();

        public List<String> getMergedPartitionKeys();

        public Optional<TableDistribution> getMergedTableDistribution();
    }
}

