/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableFunctionScan;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalCorrelate;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalValues;
import org.apache.flink.table.planner.plan.rules.physical.batch.ImmutableBatchPhysicalConstantTableFunctionScanRule;
import org.immutables.value.Value;
import scala.Option;

@Value.Enclosing
public class BatchPhysicalConstantTableFunctionScanRule
extends RelRule<BatchPhysicalConstantTableFunctionScanRuleConfig> {
    public static final BatchPhysicalConstantTableFunctionScanRule INSTANCE = BatchPhysicalConstantTableFunctionScanRuleConfig.DEFAULT.toRule();

    protected BatchPhysicalConstantTableFunctionScanRule(BatchPhysicalConstantTableFunctionScanRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)call.rel(0);
        return RexUtil.isConstant(scan.getCall()) && scan.getInputs().isEmpty();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)call.rel(0);
        RelOptCluster cluster = scan.getCluster();
        RelTraitSet traitSet = call.getPlanner().emptyTraitSet().replace(FlinkConventions.BATCH_PHYSICAL());
        BatchPhysicalValues values = new BatchPhysicalValues(cluster, traitSet, ImmutableList.of(ImmutableList.of()), cluster.getTypeFactory().createStructType(ImmutableList.of(), ImmutableList.of()));
        BatchPhysicalCorrelate correlate = new BatchPhysicalCorrelate(cluster, traitSet, values, scan, (Option<RexNode>)Option.empty(), scan.getRowType(), JoinRelType.INNER);
        call.transformTo(correlate);
    }

    @Value.Immutable(singleton=false)
    public static interface BatchPhysicalConstantTableFunctionScanRuleConfig
    extends RelRule.Config {
        public static final BatchPhysicalConstantTableFunctionScanRuleConfig DEFAULT = ImmutableBatchPhysicalConstantTableFunctionScanRule.BatchPhysicalConstantTableFunctionScanRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(FlinkLogicalTableFunctionScan.class).anyInputs()).withDescription("BatchPhysicalConstantTableFunctionScanRule").as(BatchPhysicalConstantTableFunctionScanRuleConfig.class);

        @Override
        default public BatchPhysicalConstantTableFunctionScanRule toRule() {
            return new BatchPhysicalConstantTableFunctionScanRule(this);
        }
    }
}

