/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.batch;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.FlinkRelNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecSortLimit;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalRel;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil$;
import org.apache.flink.table.planner.plan.utils.SortUtil$;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import scala.Enumeration;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001\u0002\n\u0014\u0001\u0019B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011A\u0003!\u0011!Q\u0001\nECQa\u0016\u0001\u0005\u0002aCq!\u0019\u0001C\u0002\u0013%!\r\u0003\u0004g\u0001\u0001\u0006Ia\u0019\u0005\bO\u0002\u0011\r\u0011\"\u0003c\u0011\u0019A\u0007\u0001)A\u0005G\")\u0011\u000e\u0001C!U\")!\u000f\u0001C!g\")\u0011\u0010\u0001C!u\"9\u0011Q\u0002\u0001\u0005B\u0005=\u0001bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0002\u0017\u0005\u0006$8\r\u001b)isNL7-\u00197T_J$H*[7ji*\u0011A#F\u0001\u0006E\u0006$8\r\u001b\u0006\u0003-]\t\u0001\u0002\u001d5zg&\u001c\u0017\r\u001c\u0006\u00031e\tQA\\8eKNT!AG\u000e\u0002\tAd\u0017M\u001c\u0006\u00039u\tq\u0001\u001d7b]:,'O\u0003\u0002\u001f?\u0005)A/\u00192mK*\u0011\u0001%I\u0001\u0006M2Lgn\u001b\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00019\u0013\u0007\u0005\u0002)_5\t\u0011F\u0003\u0002+W\u0005!1m\u001c:f\u0015\taS&A\u0002sK2T!AL\u0011\u0002\u000f\r\fGnY5uK&\u0011\u0001'\u000b\u0002\u0005'>\u0014H\u000f\u0005\u00023g5\t1#\u0003\u00025'\t\u0001\")\u0019;dQBC\u0017p]5dC2\u0014V\r\\\u0001\bG2,8\u000f^3s!\t9\u0014(D\u00019\u0015\tQR&\u0003\u0002;q\ti!+\u001a7PaR\u001cE.^:uKJ\f\u0001\u0002\u001e:bSR\u001cV\r\u001e\t\u0003ouJ!A\u0010\u001d\u0003\u0017I+G\u000e\u0016:bSR\u001cV\r^\u0001\tS:\u0004X\u000f\u001e*fYB\u0011\u0011IQ\u0007\u0002W%\u00111i\u000b\u0002\b%\u0016dgj\u001c3f\u00035\u0019xN\u001d;D_2d\u0017\r^5p]B\u0011\u0011IR\u0005\u0003\u000f.\u0012ABU3m\u0007>dG.\u0019;j_:\faa\u001c4gg\u0016$\bC\u0001&N\u001b\u0005Y%B\u0001'.\u0003\r\u0011X\r_\u0005\u0003\u001d.\u0013qAU3y\u001d>$W-A\u0003gKR\u001c\u0007.\u0001\u0005jg\u001ecwNY1m!\t\u0011V+D\u0001T\u0015\u0005!\u0016!B:dC2\f\u0017B\u0001,T\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD\u0003C-[7rkfl\u00181\u0011\u0005I\u0002\u0001\"B\u001b\t\u0001\u00041\u0004\"B\u001e\t\u0001\u0004a\u0004\"B \t\u0001\u0004\u0001\u0005\"\u0002#\t\u0001\u0004)\u0005\"\u0002%\t\u0001\u0004I\u0005\"B(\t\u0001\u0004I\u0005\"\u0002)\t\u0001\u0004\t\u0016A\u00037j[&$8\u000b^1siV\t1\r\u0005\u0002SI&\u0011Qm\u0015\u0002\u0005\u0019>tw-A\u0006mS6LGo\u0015;beR\u0004\u0013\u0001\u00037j[&$XI\u001c3\u0002\u00131LW.\u001b;F]\u0012\u0004\u0013\u0001B2paf$baJ6m]B\f\b\"B\u001e\u000e\u0001\u0004a\u0004\"B7\u000e\u0001\u0004\u0001\u0015\u0001\u00038fo&s\u0007/\u001e;\t\u000b=l\u0001\u0019A#\u0002\u00199,woQ8mY\u0006$\u0018n\u001c8\t\u000b!k\u0001\u0019A%\t\u000b=k\u0001\u0019A%\u0002\u0019\u0015D\b\u000f\\1j]R+'/\\:\u0015\u0005Q<\bCA!v\u0013\t18FA\u0005SK2<&/\u001b;fe\")\u0001P\u0004a\u0001i\u0006\u0011\u0001o^\u0001\u0011KN$\u0018.\\1uKJ{woQ8v]R$\"a\u001f@\u0011\u0005Ic\u0018BA?T\u0005\u0019!u.\u001e2mK\"1qp\u0004a\u0001\u0003\u0003\t!!\\9\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002,\u0003!iW\r^1eCR\f\u0017\u0002BA\u0006\u0003\u000b\u0011\u0001CU3m\u001b\u0016$\u0018\rZ1uCF+XM]=\u0002\u001f\r|W\u000e];uKN+GNZ\"pgR$b!!\u0005\u0002\u0018\u0005}\u0001cA\u001c\u0002\u0014%\u0019\u0011Q\u0003\u001d\u0003\u0015I+Gn\u00149u\u0007>\u001cH\u000f\u0003\u0004\u001d!\u0001\u0007\u0011\u0011\u0004\t\u0004o\u0005m\u0011bAA\u000fq\ti!+\u001a7PaR\u0004F.\u00198oKJDaa \tA\u0002\u0005\u0005\u0011a\u0005;sC:\u001cH.\u0019;f)>,\u00050Z2O_\u0012,GCAA\u0013a\u0011\t9#a\u000e\u0011\r\u0005%\u0012qFA\u001a\u001b\t\tYCC\u0002\u0002.]\tA!\u001a=fG&!\u0011\u0011GA\u0016\u0005!)\u00050Z2O_\u0012,\u0007\u0003BA\u001b\u0003oa\u0001\u0001B\u0006\u0002:E\t\t\u0011!A\u0003\u0002\u0005m\"aA0%cE!\u0011QHA\"!\r\u0011\u0016qH\u0005\u0004\u0003\u0003\u001a&a\u0002(pi\"Lgn\u001a\t\u0004%\u0006\u0015\u0013bAA$'\n\u0019\u0011I\\=")
public class BatchPhysicalSortLimit
extends Sort
implements BatchPhysicalRel {
    private final RelOptCluster cluster;
    private final RelCollation sortCollation;
    private final RexNode fetch;
    private final boolean isGlobal;
    private final long limitStart;
    private final long limitEnd;

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        return FlinkPhysicalRel.satisfyTraits$(this, requiredTraitSet);
    }

    @Override
    public ExecNode<?> translateToExecNode(boolean isCompiled) {
        return FlinkPhysicalRel.translateToExecNode$(this, isCompiled);
    }

    @Override
    public String getRelDetailedDescription() {
        return FlinkRelNode.getRelDetailedDescription$(this);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, sqlExplainLevel);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionDetail) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionDetail);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat, SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionFormat, sqlExplainLevel);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat, Enumeration.Value expressionDetail) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionFormat, expressionDetail);
    }

    @Override
    public Enumeration.Value convertToExpressionDetail(SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.convertToExpressionDetail$(this, sqlExplainLevel);
    }

    private long limitStart() {
        return this.limitStart;
    }

    private long limitEnd() {
        return this.limitEnd;
    }

    @Override
    public Sort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new BatchPhysicalSortLimit(this.cluster, traitSet, newInput, newCollation, offset, fetch, this.isGlobal);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.input("input", this.getInput()).item("orderBy", RelExplainUtil$.MODULE$.collationToString(this.sortCollation, this.getRowType())).item("offset", BoxesRunTime.boxToLong((long)this.limitStart())).item("fetch", RelExplainUtil$.MODULE$.fetchToString(this.fetch)).item("global", BoxesRunTime.boxToBoolean((boolean)this.isGlobal));
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        Double inputRows = mq.getRowCount(this.getInput());
        if (inputRows == null) {
            return Predef$.MODULE$.Double2double(inputRows);
        }
        double rowCount = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(Predef$.MODULE$.Double2double(inputRows) - (double)this.limitStart()), 1.0);
        if (this.fetch != null) {
            return RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(rowCount), (double)RexLiteral.intValue(this.fetch));
        }
        return rowCount;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Double inputRowCnt = mq.getRowCount(this.getInput());
        double heapLen = Math.min(Predef$.MODULE$.Double2double(inputRowCnt), (double)this.limitEnd());
        int numOfSort = this.sortCollation.getFieldCollations().size();
        double cpuCost = (double)(FlinkCost$.MODULE$.COMPARE_CPU_COST() * numOfSort) * Predef$.MODULE$.Double2double(inputRowCnt) * Math.log(heapLen);
        double memCost = heapLen * Predef$.MODULE$.Double2double(mq.getAverageRowSize(this));
        Double rowCount = mq.getRowCount(this);
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        return costFactory.makeCost(Predef$.MODULE$.Double2double(rowCount), cpuCost, 0.0, 0.0, memCost);
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        InputProperty.RequiredDistribution requiredDistribution = this.isGlobal ? InputProperty.SINGLETON_DISTRIBUTION : InputProperty.UNKNOWN_DISTRIBUTION;
        return new BatchExecSortLimit((ReadableConfig)ShortcutUtils.unwrapTableConfig(this), SortUtil$.MODULE$.getSortSpec((Seq<RelFieldCollation>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.sortCollation.getFieldCollations())), this.limitStart(), this.limitEnd(), this.isGlobal, InputProperty.builder().requiredDistribution(requiredDistribution).damBehavior(InputProperty.DamBehavior.END_INPUT).build(), FlinkTypeFactory$.MODULE$.toLogicalRowType(this.getRowType()), this.getRelDetailedDescription());
    }

    public BatchPhysicalSortLimit(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputRel, RelCollation sortCollation, RexNode offset, RexNode fetch, boolean isGlobal) {
        this.cluster = cluster;
        this.sortCollation = sortCollation;
        this.fetch = fetch;
        this.isGlobal = isGlobal;
        super(cluster, traitSet, inputRel, sortCollation, offset, fetch);
        FlinkRelNode.$init$(this);
        FlinkPhysicalRel.$init$(this);
        this.limitStart = SortUtil$.MODULE$.getLimitStart(offset);
        this.limitEnd = SortUtil$.MODULE$.getLimitEnd(offset, fetch);
    }
}

