/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.ddl.SqlCreateTableAs;
import org.apache.flink.sql.parser.ddl.SqlCreateTableLike;
import org.apache.flink.sql.parser.ddl.SqlTableLike;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.CreateTableASOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.planner.calcite.FlinkCalciteSqlValidator;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.SqlRewriterUtils;
import org.apache.flink.table.planner.operations.MergeTableAsUtil;
import org.apache.flink.table.planner.operations.MergeTableLikeUtil;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversion;
import org.apache.flink.table.planner.utils.OperationConverterUtils;

class SqlCreateTableConverter {
    private final MergeTableLikeUtil mergeTableLikeUtil;
    private final MergeTableAsUtil mergeTableAsUtil;
    private final CatalogManager catalogManager;
    private final FlinkTypeFactory typeFactory;
    private final SqlRewriterUtils rewriterUtils;

    SqlCreateTableConverter(FlinkCalciteSqlValidator sqlValidator, CatalogManager catalogManager, Function<SqlNode, String> escapeExpression) {
        this.mergeTableLikeUtil = new MergeTableLikeUtil(sqlValidator, escapeExpression, catalogManager.getDataTypeFactory());
        this.mergeTableAsUtil = new MergeTableAsUtil(sqlValidator, escapeExpression, catalogManager.getDataTypeFactory());
        this.catalogManager = catalogManager;
        this.typeFactory = (FlinkTypeFactory)sqlValidator.getTypeFactory();
        this.rewriterUtils = new SqlRewriterUtils(sqlValidator);
    }

    Operation convertCreateTable(SqlCreateTable sqlCreateTable) {
        ResolvedCatalogTable catalogTable = this.createCatalogTable(sqlCreateTable);
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlCreateTable.fullTableName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new CreateTableOperation(identifier, catalogTable, sqlCreateTable.isIfNotExists(), sqlCreateTable.isTemporary());
    }

    Operation convertCreateTableAS(FlinkPlannerImpl flinkPlanner, SqlCreateTableAs sqlCreateTableAs) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlCreateTableAs.fullTableName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        SqlNode asQuerySqlNode = sqlCreateTableAs.getAsQuery();
        SqlNode validatedAsQuery = flinkPlanner.validate(asQuerySqlNode);
        PlannerQueryOperation query = (PlannerQueryOperation)SqlNodeToOperationConversion.convert(flinkPlanner, this.catalogManager, validatedAsQuery).orElseThrow(() -> new TableException("CTAS unsupported node type " + validatedAsQuery.getClass().getSimpleName()));
        ResolvedCatalogTable tableWithResolvedSchema = this.createCatalogTable(sqlCreateTableAs, query.getResolvedSchema());
        query = this.mergeTableAsUtil.maybeRewriteQuery(this.catalogManager, flinkPlanner, query, validatedAsQuery, tableWithResolvedSchema);
        CreateTableOperation createTableOperation = new CreateTableOperation(identifier, tableWithResolvedSchema, sqlCreateTableAs.isIfNotExists(), sqlCreateTableAs.isTemporary());
        return new CreateTableASOperation(createTableOperation, Collections.emptyMap(), (QueryOperation)query, false);
    }

    private ResolvedCatalogTable createCatalogTable(SqlCreateTableAs sqlCreateTableAs, ResolvedSchema querySchema) {
        Map<String, String> tableOptions = sqlCreateTableAs.getPropertyList().getList().stream().collect(Collectors.toMap(p -> ((SqlTableOption)p).getKeyString(), p -> ((SqlTableOption)p).getValueString()));
        String tableComment = OperationConverterUtils.getTableComment(sqlCreateTableAs.getComment());
        Schema mergedSchema = sqlCreateTableAs.isSchemaWithColumnsIdentifiersOnly() ? this.mergeTableAsUtil.reorderSchema(sqlCreateTableAs.getColumnList(), querySchema) : this.mergeTableAsUtil.mergeSchemas(sqlCreateTableAs.getColumnList(), sqlCreateTableAs.getWatermark().orElse(null), sqlCreateTableAs.getFullConstraints(), querySchema);
        Optional<TableDistribution> tableDistribution = Optional.ofNullable(sqlCreateTableAs.getDistribution()).map(OperationConverterUtils::getDistributionFromSqlDistribution);
        List<String> partitionKeys = this.getPartitionKeyColumnNames(sqlCreateTableAs.getPartitionKeyList());
        this.verifyPartitioningColumnsExist(mergedSchema, partitionKeys);
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(mergedSchema).comment(tableComment).distribution((TableDistribution)tableDistribution.orElse(null)).options(tableOptions).partitionKeys(partitionKeys).build();
        return this.catalogManager.resolveCatalogTable(catalogTable);
    }

    private ResolvedCatalogTable createCatalogTable(SqlCreateTable sqlCreateTable) {
        Map sourceProperties;
        List<SqlTableLike.SqlTableLikeOption> likeOptions;
        List sourcePartitionKeys;
        Optional sourceTableDistribution;
        Schema sourceTableSchema;
        if (sqlCreateTable instanceof SqlCreateTableLike) {
            SqlTableLike sqlTableLike = ((SqlCreateTableLike)sqlCreateTable).getTableLike();
            CatalogTable table = this.lookupLikeSourceTable(sqlTableLike);
            sourceTableSchema = table.getUnresolvedSchema();
            sourceTableDistribution = table.getDistribution();
            sourcePartitionKeys = table.getPartitionKeys();
            likeOptions = sqlTableLike.getOptions();
            sourceProperties = table.getOptions();
        } else {
            sourceTableSchema = Schema.newBuilder().build();
            sourceTableDistribution = Optional.empty();
            sourcePartitionKeys = Collections.emptyList();
            likeOptions = Collections.emptyList();
            sourceProperties = Collections.emptyMap();
        }
        Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies = this.mergeTableLikeUtil.computeMergingStrategies(likeOptions);
        Map<String, String> mergedOptions = this.mergeOptions(sqlCreateTable, sourceProperties, mergingStrategies);
        Optional<SqlTableConstraint> primaryKey = sqlCreateTable.getFullConstraints().stream().filter(SqlTableConstraint::isPrimaryKey).findAny();
        Schema mergedSchema = this.mergeTableLikeUtil.mergeTables(mergingStrategies, sourceTableSchema, sqlCreateTable.getColumnList().getList(), sqlCreateTable.getWatermark().map(Collections::singletonList).orElseGet(Collections::emptyList), primaryKey.orElse(null));
        Optional<TableDistribution> mergedTableDistribution = this.mergeDistribution(sourceTableDistribution, sqlCreateTable, mergingStrategies);
        List<String> partitionKeys = this.mergePartitions(sourcePartitionKeys, sqlCreateTable.getPartitionKeyList(), mergingStrategies);
        this.verifyPartitioningColumnsExist(mergedSchema, partitionKeys);
        String tableComment = OperationConverterUtils.getTableComment(sqlCreateTable.getComment());
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(mergedSchema).comment(tableComment).distribution((TableDistribution)mergedTableDistribution.orElse(null)).options(new HashMap<String, String>(mergedOptions)).partitionKeys(partitionKeys).build();
        return this.catalogManager.resolveCatalogTable(catalogTable);
    }

    private CatalogTable lookupLikeSourceTable(SqlTableLike sqlTableLike) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of(sqlTableLike.getSourceTable().names);
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        ContextResolvedTable lookupResult = (ContextResolvedTable)this.catalogManager.getTable(identifier).orElseThrow(() -> new ValidationException(String.format("Source table '%s' of the LIKE clause not found in the catalog, at %s", identifier, sqlTableLike.getSourceTable().getParserPosition())));
        if (!(lookupResult.getResolvedTable() instanceof CatalogTable)) {
            throw new ValidationException(String.format("Source table '%s' of the LIKE clause can not be a VIEW, at %s", identifier, sqlTableLike.getSourceTable().getParserPosition()));
        }
        return (CatalogTable)lookupResult.getResolvedTable();
    }

    private void verifyPartitioningColumnsExist(Schema mergedSchema, List<String> partitionKeys) {
        Set columnNames = mergedSchema.getColumns().stream().map(Schema.UnresolvedColumn::getName).collect(Collectors.toCollection(LinkedHashSet::new));
        for (String partitionKey : partitionKeys) {
            if (columnNames.contains(partitionKey)) continue;
            throw new ValidationException(String.format("Partition column '%s' not defined in the table schema. Available columns: [%s]", partitionKey, columnNames.stream().collect(Collectors.joining("', '", "'", "'"))));
        }
    }

    private Optional<TableDistribution> mergeDistribution(Optional<TableDistribution> sourceTableDistribution, SqlCreateTable sqlCreateTable, Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies) {
        Optional<TableDistribution> derivedTabledDistribution = Optional.empty();
        if (sqlCreateTable.getDistribution() != null) {
            TableDistribution distribution = OperationConverterUtils.getDistributionFromSqlDistribution(sqlCreateTable.getDistribution());
            derivedTabledDistribution = Optional.of(distribution);
        }
        return this.mergeTableLikeUtil.mergeDistribution(mergingStrategies.get((Object)SqlTableLike.FeatureOption.DISTRIBUTION), sourceTableDistribution, derivedTabledDistribution);
    }

    private List<String> getPartitionKeyColumnNames(SqlNodeList partitionKey) {
        return partitionKey.getList().stream().map(p -> ((SqlIdentifier)p).getSimple()).collect(Collectors.toList());
    }

    private List<String> mergePartitions(List<String> sourcePartitionKeys, SqlNodeList derivedPartitionKeys, Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies) {
        return this.mergeTableLikeUtil.mergePartitions(mergingStrategies.get((Object)SqlTableLike.FeatureOption.PARTITIONS), sourcePartitionKeys, this.getPartitionKeyColumnNames(derivedPartitionKeys));
    }

    private Map<String, String> mergeOptions(SqlCreateTable sqlCreateTable, Map<String, String> sourceProperties, Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies) {
        HashMap<String, String> properties = new HashMap<String, String>();
        sqlCreateTable.getPropertyList().getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        return this.mergeTableLikeUtil.mergeOptions(mergingStrategies.get((Object)SqlTableLike.FeatureOption.OPTIONS), sourceProperties, properties);
    }
}

