/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.analyze;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.analyze.PlanAdvice;
import org.apache.flink.table.planner.analyze.PlanAnalyzer;
import org.apache.flink.table.planner.plan.nodes.FlinkRelNode;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLookupJoin;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.optimize.StreamNonDeterministicUpdatePlanVisitor;
import org.apache.flink.table.planner.utils.ShortcutUtils;

@Internal
public class NonDeterministicUpdateAnalyzer
implements PlanAnalyzer {
    public static final NonDeterministicUpdateAnalyzer INSTANCE = new NonDeterministicUpdateAnalyzer();
    private static final StreamNonDeterministicUpdatePlanVisitor NDU_VISITOR = new StreamNonDeterministicUpdatePlanVisitor();

    private NonDeterministicUpdateAnalyzer() {
    }

    @Override
    public Optional<PlanAnalyzer.AnalyzedResult> analyze(FlinkRelNode rel) {
        boolean ignoreNDU;
        boolean bl = ignoreNDU = ShortcutUtils.unwrapTableConfig(rel).get(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY) == OptimizerConfigOptions.NonDeterministicUpdateStrategy.IGNORE;
        if (rel instanceof StreamPhysicalRel && ignoreNDU) {
            try {
                StreamPhysicalRel originalRel = (StreamPhysicalRel)rel;
                StreamPhysicalRel resolvedRel = NDU_VISITOR.visit(originalRel);
                List<Boolean> originalRequirement = this.requireUpsertMaterialize(originalRel);
                List<Boolean> resolvedRequirement = this.requireUpsertMaterialize(resolvedRel);
                boolean mismatch = IntStream.range(0, originalRequirement.size()).filter(i -> !((Boolean)originalRequirement.get(i)).equals(resolvedRequirement.get(i))).findAny().isPresent();
                if (mismatch) {
                    return this.getAdvice(String.format("You might want to enable upsert materialization for look up join operator by configuring ('%s' to '%s') to resolve the correctness issue caused by 'Non-Deterministic Updates' (NDU) in a changelog pipeline.", OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY.key(), OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE));
                }
            }
            catch (TableException e) {
                return this.getAdvice(e.getMessage());
            }
        }
        return Optional.empty();
    }

    private Optional<PlanAnalyzer.AnalyzedResult> getAdvice(final String content) {
        return Optional.of(new PlanAnalyzer.AnalyzedResult(){

            @Override
            public PlanAdvice getAdvice() {
                return new PlanAdvice(PlanAdvice.Kind.WARNING, PlanAdvice.Scope.QUERY_LEVEL, content);
            }

            @Override
            public List<Integer> getTargetIds() {
                return Collections.emptyList();
            }
        });
    }

    private List<Boolean> requireUpsertMaterialize(StreamPhysicalRel rel) {
        final ArrayList<Boolean> requireUpsertMaterialize = new ArrayList<Boolean>();
        rel.accept(new RelShuttleImpl(){

            @Override
            public RelNode visit(RelNode other) {
                if (other instanceof StreamPhysicalLookupJoin) {
                    requireUpsertMaterialize.add(((StreamPhysicalLookupJoin)other).upsertMaterialize());
                }
                return super.visit(other);
            }
        });
        return requireUpsertMaterialize;
    }
}

