/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableSchema;

@PublicEvolving
public interface CatalogBaseTable {
    public TableKind getTableKind();

    public Map<String, String> getOptions();

    @Deprecated
    default public TableSchema getSchema() {
        return null;
    }

    default public Schema getUnresolvedSchema() {
        TableSchema oldSchema = this.getSchema();
        if (oldSchema == null) {
            throw new UnsupportedOperationException("A CatalogBaseTable must implement getUnresolvedSchema().");
        }
        return oldSchema.toSchema();
    }

    public String getComment();

    public CatalogBaseTable copy();

    public Optional<String> getDescription();

    public Optional<String> getDetailedDescription();

    @PublicEvolving
    public static enum TableKind {
        TABLE,
        MATERIALIZED_TABLE,
        VIEW;

    }
}

