/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.utils;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.transformations.LegacySourceTransformation;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodePlanDumper;
import org.apache.flink.table.planner.plan.nodes.exec.utils.TransformationMetadata;

public class ExecNodeUtil {
    public static <T> void setManagedMemoryWeight(Transformation<T> transformation, long memoryBytes) {
        int weightInMebibyte;
        Optional previousWeight;
        if (memoryBytes > 0L && (previousWeight = transformation.declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.OPERATOR, weightInMebibyte = Math.max(1, (int)(memoryBytes >> 20)))).isPresent()) {
            throw new TableException("Managed memory weight has been set, this should not happen.");
        }
    }

    public static <I, O> OneInputTransformation<I, O> createOneInputTransformation(Transformation<I> input, TransformationMetadata transformationMeta, StreamOperator<O> operator, TypeInformation<O> outputType, int parallelism, boolean parallelismConfigured) {
        return ExecNodeUtil.createOneInputTransformation(input, transformationMeta, operator, outputType, parallelism, 0L, parallelismConfigured);
    }

    public static <I, O> OneInputTransformation<I, O> createOneInputTransformation(Transformation<I> input, String name, String desc, StreamOperator<O> operator, TypeInformation<O> outputType, int parallelism, boolean parallelismConfigured) {
        return ExecNodeUtil.createOneInputTransformation(input, new TransformationMetadata(name, desc), operator, outputType, parallelism, 0L, parallelismConfigured);
    }

    public static <I, O> OneInputTransformation<I, O> createOneInputTransformation(Transformation<I> input, TransformationMetadata transformationMeta, StreamOperator<O> operator, TypeInformation<O> outputType, int parallelism, long memoryBytes, boolean parallelismConfigured) {
        return ExecNodeUtil.createOneInputTransformation(input, transformationMeta, SimpleOperatorFactory.of(operator), outputType, parallelism, memoryBytes, parallelismConfigured);
    }

    public static <I, O> OneInputTransformation<I, O> createOneInputTransformation(Transformation<I> input, TransformationMetadata transformationMeta, StreamOperatorFactory<O> operatorFactory, TypeInformation<O> outputType, int parallelism, boolean parallelismConfigured) {
        return ExecNodeUtil.createOneInputTransformation(input, transformationMeta, operatorFactory, outputType, parallelism, 0L, parallelismConfigured);
    }

    public static <I, O> OneInputTransformation<I, O> createOneInputTransformation(Transformation<I> input, String name, String desc, StreamOperatorFactory<O> operatorFactory, TypeInformation<O> outputType, int parallelism, boolean parallelismConfigured) {
        return ExecNodeUtil.createOneInputTransformation(input, new TransformationMetadata(name, desc), operatorFactory, outputType, parallelism, 0L, parallelismConfigured);
    }

    public static <I, O> OneInputTransformation<I, O> createOneInputTransformation(Transformation<I> input, String name, String desc, StreamOperatorFactory<O> operatorFactory, TypeInformation<O> outputType, int parallelism, long memoryBytes, boolean parallelismConfigured) {
        return ExecNodeUtil.createOneInputTransformation(input, new TransformationMetadata(name, desc), operatorFactory, outputType, parallelism, memoryBytes, parallelismConfigured);
    }

    public static <I, O> OneInputTransformation<I, O> createOneInputTransformation(Transformation<I> input, TransformationMetadata transformationMeta, StreamOperatorFactory<O> operatorFactory, TypeInformation<O> outputType, int parallelism, long memoryBytes, boolean parallelismConfigured) {
        OneInputTransformation transformation = new OneInputTransformation(input, transformationMeta.getName(), operatorFactory, outputType, parallelism, parallelismConfigured);
        ExecNodeUtil.setManagedMemoryWeight(transformation, memoryBytes);
        transformationMeta.fill(transformation);
        return transformation;
    }

    public static <IN1, IN2, O> TwoInputTransformation<IN1, IN2, O> createTwoInputTransformation(Transformation<IN1> input1, Transformation<IN2> input2, TransformationMetadata transformationMeta, TwoInputStreamOperator<IN1, IN2, O> operator, TypeInformation<O> outputType, int parallelism, boolean parallelismConfigured) {
        return ExecNodeUtil.createTwoInputTransformation(input1, input2, transformationMeta, operator, outputType, parallelism, 0L, parallelismConfigured);
    }

    public static <IN1, IN2, O> TwoInputTransformation<IN1, IN2, O> createTwoInputTransformation(Transformation<IN1> input1, Transformation<IN2> input2, String name, String desc, TwoInputStreamOperator<IN1, IN2, O> operator, TypeInformation<O> outputType, int parallelism) {
        return ExecNodeUtil.createTwoInputTransformation(input1, input2, new TransformationMetadata(name, desc), operator, outputType, parallelism, 0L);
    }

    public static <IN1, IN2, O> TwoInputTransformation<IN1, IN2, O> createTwoInputTransformation(Transformation<IN1> input1, Transformation<IN2> input2, TransformationMetadata transformationMeta, TwoInputStreamOperator<IN1, IN2, O> operator, TypeInformation<O> outputType, int parallelism, long memoryBytes) {
        return ExecNodeUtil.createTwoInputTransformation(input1, input2, transformationMeta, SimpleOperatorFactory.of(operator), outputType, parallelism, memoryBytes);
    }

    public static <IN1, IN2, O> TwoInputTransformation<IN1, IN2, O> createTwoInputTransformation(Transformation<IN1> input1, Transformation<IN2> input2, TransformationMetadata transformationMeta, TwoInputStreamOperator<IN1, IN2, O> operator, TypeInformation<O> outputType, int parallelism, long memoryBytes, boolean parallelismConfigured) {
        return ExecNodeUtil.createTwoInputTransformation(input1, input2, transformationMeta, SimpleOperatorFactory.of(operator), outputType, parallelism, memoryBytes, parallelismConfigured);
    }

    public static <IN1, IN2, O> TwoInputTransformation<IN1, IN2, O> createTwoInputTransformation(Transformation<IN1> input1, Transformation<IN2> input2, String name, String desc, TwoInputStreamOperator<IN1, IN2, O> operator, TypeInformation<O> outputType, int parallelism, long memoryBytes) {
        return ExecNodeUtil.createTwoInputTransformation(input1, input2, new TransformationMetadata(name, desc), SimpleOperatorFactory.of(operator), outputType, parallelism, memoryBytes);
    }

    public static <I1, I2, O> TwoInputTransformation<I1, I2, O> createTwoInputTransformation(Transformation<I1> input1, Transformation<I2> input2, TransformationMetadata transformationMeta, StreamOperatorFactory<O> operatorFactory, TypeInformation<O> outputType, int parallelism, long memoryBytes) {
        TwoInputTransformation transformation = new TwoInputTransformation(input1, input2, transformationMeta.getName(), operatorFactory, outputType, parallelism);
        ExecNodeUtil.setManagedMemoryWeight(transformation, memoryBytes);
        transformationMeta.fill(transformation);
        return transformation;
    }

    public static <I1, I2, O> TwoInputTransformation<I1, I2, O> createTwoInputTransformation(Transformation<I1> input1, Transformation<I2> input2, TransformationMetadata transformationMeta, StreamOperatorFactory<O> operatorFactory, TypeInformation<O> outputType, int parallelism, long memoryBytes, boolean parallelismConfigured) {
        TwoInputTransformation transformation = new TwoInputTransformation(input1, input2, transformationMeta.getName(), operatorFactory, outputType, parallelism, parallelismConfigured);
        ExecNodeUtil.setManagedMemoryWeight(transformation, memoryBytes);
        transformationMeta.fill(transformation);
        return transformation;
    }

    public static <I1, I2, O> TwoInputTransformation<I1, I2, O> createTwoInputTransformation(Transformation<I1> input1, Transformation<I2> input2, String name, String desc, StreamOperatorFactory<O> operatorFactory, TypeInformation<O> outputType, int parallelism, long memoryBytes, boolean parallelismConfigured) {
        return ExecNodeUtil.createTwoInputTransformation(input1, input2, new TransformationMetadata(name, desc), operatorFactory, outputType, parallelism, memoryBytes, parallelismConfigured);
    }

    public static String getMultipleInputDescription(ExecNode<?> rootNode, List<ExecNode<?>> inputNodes, List<InputProperty> inputProperties) {
        boolean hasDiffReadOrder;
        String members = ExecNodePlanDumper.treeToString(rootNode, inputNodes, true).replace("\n", "\\n");
        StringBuilder sb = new StringBuilder();
        sb.append("MultipleInput(");
        List readOrders = inputProperties.stream().map(InputProperty::getPriority).map(Object::toString).collect(Collectors.toList());
        boolean bl = hasDiffReadOrder = readOrders.stream().distinct().count() > 1L;
        if (hasDiffReadOrder) {
            sb.append("readOrder=[").append(String.join((CharSequence)",", readOrders)).append("], ");
        }
        sb.append("members=[\\n").append(members).append("]");
        sb.append(")");
        return sb.toString();
    }

    public static void makeLegacySourceTransformationsBounded(Transformation<?> transformation) {
        if (transformation instanceof LegacySourceTransformation) {
            ((LegacySourceTransformation)transformation).setBoundedness(Boundedness.BOUNDED);
        }
        transformation.getInputs().forEach(ExecNodeUtil::makeLegacySourceTransformationsBounded);
    }
}

