/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.logical;

import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

@JsonTypeName(value="TimeAttribute")
public class TimeAttributeWindowingStrategy
extends WindowingStrategy {
    public static final String FIELD_NAME_TIME_ATTRIBUTE_INDEX = "timeAttributeIndex";
    @JsonProperty(value="timeAttributeIndex")
    private final int timeAttributeIndex;

    @JsonCreator
    public TimeAttributeWindowingStrategy(@JsonProperty(value="window") WindowSpec window, @JsonProperty(value="timeAttributeType") LogicalType timeAttributeType, @JsonProperty(value="timeAttributeIndex") int timeAttributeIndex) {
        super(window, timeAttributeType);
        this.timeAttributeIndex = timeAttributeIndex;
    }

    @Override
    public String toSummaryString(String[] inputFieldNames) {
        Preconditions.checkArgument((this.timeAttributeIndex >= 0 && this.timeAttributeIndex < inputFieldNames.length ? 1 : 0) != 0);
        String windowing = String.format("time_col=[%s]", inputFieldNames[this.timeAttributeIndex]);
        return this.window.toSummaryString(windowing, inputFieldNames);
    }

    public int getTimeAttributeIndex() {
        return this.timeAttributeIndex;
    }
}

