/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.functions.DeclarativeAggregateFunction;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.TimestampType;

public abstract class MinAggFunction
extends DeclarativeAggregateFunction {
    private final UnresolvedReferenceExpression min = ApiExpressionUtils.unresolvedRef((String)"min");

    public int operandCount() {
        return 1;
    }

    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[]{this.min};
    }

    public DataType[] getAggBufferTypes() {
        return new DataType[]{this.getResultType()};
    }

    public Expression[] initialValuesExpressions() {
        return new Expression[]{ExpressionBuilder.nullOf(this.getResultType())};
    }

    public Expression[] accumulateExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.min, (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.min), (Expression)this.operand(0), (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.lessThan((Expression)this.operand(0), (Expression)this.min), (Expression)this.operand(0), (Expression)this.min)))};
    }

    public Expression[] retractExpressions() {
        return new Expression[0];
    }

    public Expression[] mergeExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.mergeOperand(this.min)), (Expression)this.min, (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.min), (Expression)this.mergeOperand(this.min), (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.lessThan((Expression)this.mergeOperand(this.min), (Expression)this.min), (Expression)this.mergeOperand(this.min), (Expression)this.min)))};
    }

    public Expression getValueExpression() {
        return this.min;
    }

    public static class TimestampLtzMinAggFunction
    extends MinAggFunction {
        private final LocalZonedTimestampType type;

        public TimestampLtzMinAggFunction(LocalZonedTimestampType type) {
            this.type = type;
        }

        public DataType getResultType() {
            return DataTypes.TIMESTAMP_LTZ((int)this.type.getPrecision());
        }
    }

    public static class TimestampMinAggFunction
    extends MinAggFunction {
        private final TimestampType type;

        public TimestampMinAggFunction(TimestampType type) {
            this.type = type;
        }

        public DataType getResultType() {
            return DataTypes.TIMESTAMP((int)this.type.getPrecision());
        }
    }

    public static class TimeMinAggFunction
    extends MinAggFunction {
        public DataType getResultType() {
            return DataTypes.TIME((int)0);
        }
    }

    public static class DateMinAggFunction
    extends MinAggFunction {
        public DataType getResultType() {
            return DataTypes.DATE();
        }
    }

    public static class StringMinAggFunction
    extends MinAggFunction {
        public DataType getResultType() {
            return DataTypes.STRING();
        }
    }

    public static class BooleanMinAggFunction
    extends MinAggFunction {
        public DataType getResultType() {
            return DataTypes.BOOLEAN();
        }
    }

    public static class DecimalMinAggFunction
    extends MinAggFunction {
        private final DataType resultType;

        public DecimalMinAggFunction(DecimalType decimalType) {
            this.resultType = DataTypes.DECIMAL((int)decimalType.getPrecision(), (int)decimalType.getScale());
        }

        public DataType getResultType() {
            return this.resultType;
        }
    }

    public static class DoubleMinAggFunction
    extends MinAggFunction {
        public DataType getResultType() {
            return DataTypes.DOUBLE();
        }
    }

    public static class FloatMinAggFunction
    extends MinAggFunction {
        public DataType getResultType() {
            return DataTypes.FLOAT();
        }
    }

    public static class LongMinAggFunction
    extends MinAggFunction {
        public DataType getResultType() {
            return DataTypes.BIGINT();
        }
    }

    public static class ShortMinAggFunction
    extends MinAggFunction {
        public DataType getResultType() {
            return DataTypes.SMALLINT();
        }
    }

    public static class ByteMinAggFunction
    extends MinAggFunction {
        public DataType getResultType() {
            return DataTypes.TINYINT();
        }
    }

    public static class IntMinAggFunction
    extends MinAggFunction {
        public DataType getResultType() {
            return DataTypes.INT();
        }
    }
}

