/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter.converters;

import java.util.List;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.expressions.converter.converters.CustomizedConverter;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;

@Internal
class TrimConverter
extends CustomizedConverter {
    TrimConverter() {
    }

    @Override
    public RexNode convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        SqlTrimFunction.Flag trimMode;
        TrimConverter.checkArgumentNumber(call, 4);
        List children = call.getChildren();
        ValueLiteralExpression removeLeadingExpr = (ValueLiteralExpression)children.get(0);
        Boolean removeLeading = ExpressionConverter.extractValue(removeLeadingExpr, Boolean.class);
        ValueLiteralExpression removeTrailingExpr = (ValueLiteralExpression)children.get(1);
        Boolean removeTrailing = ExpressionConverter.extractValue(removeTrailingExpr, Boolean.class);
        RexNode trimString = context.toRexNode((Expression)children.get(2));
        RexNode str = context.toRexNode((Expression)children.get(3));
        if (removeLeading.booleanValue() && removeTrailing.booleanValue()) {
            trimMode = SqlTrimFunction.Flag.BOTH;
        } else if (removeLeading.booleanValue()) {
            trimMode = SqlTrimFunction.Flag.LEADING;
        } else if (removeTrailing.booleanValue()) {
            trimMode = SqlTrimFunction.Flag.TRAILING;
        } else {
            throw new IllegalArgumentException("Unsupported trim mode.");
        }
        return context.getRelBuilder().call((SqlOperator)FlinkSqlOperatorTable.TRIM, context.getRelBuilder().getRexBuilder().makeFlag(trimMode), trimString, str);
    }
}

