/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.visualizer;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Pair;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

class InputExcludedRelWriter
implements RelWriter {
    private final Map<String, @Nullable Object> values = new LinkedHashMap<String, Object>();

    InputExcludedRelWriter() {
    }

    @Override
    public void explain(RelNode rel, List<Pair<String, @Nullable Object>> valueList) {
        valueList.forEach(pair -> {
            assert (pair.left != null);
            this.values.put((String)pair.left, pair.right);
        });
    }

    @Override
    public SqlExplainLevel getDetailLevel() {
        return SqlExplainLevel.EXPPLAN_ATTRIBUTES;
    }

    @Override
    public RelWriter input(String term, RelNode input) {
        return this;
    }

    @Override
    public RelWriter item(String term, @Nullable Object value) {
        this.values.put(term, value);
        return this;
    }

    @Override
    public RelWriter itemIf(String term, @Nullable Object value, boolean condition) {
        if (condition) {
            this.values.put(term, value);
        }
        return this;
    }

    @Override
    public RelWriter done(RelNode node) {
        return this;
    }

    @Override
    public boolean nest() {
        return false;
    }

    public String toString() {
        return this.values.toString();
    }
}

