/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.functions;

import java.time.LocalDate;
import java.util.Optional;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.types.Row;

public final class LastDatedValueFunction<T>
extends AggregateFunction<Row, Accumulator<T>> {
    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return TypeInference.newBuilder().inputTypeStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY, InputTypeStrategies.explicit((DataType)DataTypes.DATE())})).accumulatorTypeStrategy(callContext -> {
            DataType argDataType = (DataType)callContext.getArgumentDataTypes().get(0);
            DataType accDataType = DataTypes.STRUCTURED(Accumulator.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"value", (DataType)argDataType), DataTypes.FIELD((String)"date", (DataType)DataTypes.DATE())});
            return Optional.of(accDataType);
        }).outputTypeStrategy(callContext -> {
            DataType argDataType = (DataType)callContext.getArgumentDataTypes().get(0);
            DataType outputDataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"value", (DataType)argDataType), DataTypes.FIELD((String)"date", (DataType)DataTypes.DATE())});
            return Optional.of(outputDataType);
        }).build();
    }

    public Accumulator<T> createAccumulator() {
        return new Accumulator();
    }

    public void accumulate(Accumulator<T> acc, T input, LocalDate date) {
        if (input != null && (acc.date == null || date.isAfter(acc.date))) {
            acc.value = input;
            acc.date = date;
        }
    }

    public Row getValue(Accumulator<T> acc) {
        return Row.of((Object[])new Object[]{acc.value, acc.date});
    }

    public static class Accumulator<T> {
        public T value;
        public LocalDate date;
    }
}

