/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.sink;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.connector.ParallelismProvider;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;

@PublicEvolving
public interface SinkFunctionProvider
extends DynamicTableSink.SinkRuntimeProvider,
ParallelismProvider {
    public static SinkFunctionProvider of(SinkFunction<RowData> sinkFunction) {
        return () -> sinkFunction;
    }

    public static SinkFunctionProvider of(final SinkFunction<RowData> sinkFunction, final @Nullable Integer sinkParallelism) {
        return new SinkFunctionProvider(){

            @Override
            public SinkFunction<RowData> createSinkFunction() {
                return sinkFunction;
            }

            @Override
            public Optional<Integer> getParallelism() {
                return Optional.ofNullable(sinkParallelism);
            }
        };
    }

    public SinkFunction<RowData> createSinkFunction();
}

