/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.units.requests;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IFileNodeAccumulator;
import org.apache.flex.compiler.units.requests.ISyntaxTreeRequestResult;

public class SyntaxTreeRequestResult
implements ISyntaxTreeRequestResult {
    private final IASNode tree;
    private final ImmutableSet<String> includedFiles;
    private final ICompilerProblem[] problems;
    private final long lastModified;

    public SyntaxTreeRequestResult(IASNode tree, ImmutableSet<String> includedFiles, long lastModified, Collection<ICompilerProblem> problems) {
        this.tree = tree;
        this.includedFiles = includedFiles;
        this.problems = problems.toArray(new ICompilerProblem[problems.size()]);
        this.lastModified = lastModified;
    }

    public SyntaxTreeRequestResult(long lastModified, Collection<ICompilerProblem> problems) {
        this(null, (ImmutableSet<String>)ImmutableSet.of(), lastModified, problems);
    }

    @Override
    public ICompilerProblem[] getProblems() {
        return this.problems;
    }

    @Override
    public IASNode getAST() {
        return this.tree;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public Set<String> getRequiredResourceBundles() {
        if (this.tree instanceof IFileNodeAccumulator) {
            return ((IFileNodeAccumulator)((Object)this.tree)).getRequiredResourceBundles();
        }
        return Collections.emptySet();
    }

    @Override
    public ImmutableSet<String> getIncludedFiles() {
        return this.includedFiles;
    }
}

