/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.fxg.dom.richtext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flex.compiler.fxg.dom.IFXGNode;
import org.apache.flex.compiler.internal.fxg.dom.AbstractFXGNode;
import org.apache.flex.compiler.internal.fxg.dom.CDATANode;
import org.apache.flex.compiler.internal.fxg.dom.ITextNode;
import org.apache.flex.compiler.internal.fxg.dom.richtext.TextHelper;
import org.apache.flex.compiler.problems.FXGInvalidChildNodeProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;

public abstract class AbstractRichTextNode
extends AbstractFXGNode
implements ITextNode {
    protected String id;
    protected Map<String, String> textAttributes;
    protected List<ITextNode> content;
    public IFXGNode parentNode;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        this.id = value;
    }

    @Override
    public Map<String, String> getTextAttributes() {
        return this.textAttributes;
    }

    @Override
    public List<ITextNode> getTextChildren() {
        return this.content;
    }

    @Override
    public Map<String, ITextNode> getTextProperties() {
        return null;
    }

    @Override
    public void addTextProperty(String propertyName, ITextNode node, Collection<ICompilerProblem> problems) {
        problems.add(new FXGInvalidChildNodeProblem(this.getDocumentPath(), node.getStartLine(), node.getStartColumn(), node.getNodeName(), propertyName));
    }

    protected void rememberAttribute(String name, String value) {
        if (this.textAttributes == null) {
            this.textAttributes = new HashMap<String, String>(4);
        }
        this.textAttributes.put(name, value);
    }

    public void setParent(IFXGNode parent) {
        this.parentNode = parent;
    }

    @Override
    public List<IFXGNode> getChildren() {
        ArrayList<IFXGNode> children = new ArrayList<IFXGNode>();
        children.addAll(super.getChildren());
        children.addAll(this.content);
        if (this.getTextProperties() != null) {
            children.addAll(this.getTextProperties().values());
        }
        return children;
    }

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (this.content == null) {
            if (child instanceof CDATANode && TextHelper.ignorableWhitespace(((CDATANode)child).content)) {
                return;
            }
            super.addChild(child, problems);
        } else {
            super.addChild(child, problems);
        }
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if (!"id".equals(name)) {
            super.setAttribute(name, value, problems);
            return;
        }
        this.id = value;
        this.rememberAttribute(name, value);
    }
}

