/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.definitions.references;

import java.util.ArrayList;
import java.util.Set;
import org.apache.flex.abc.semantics.Name;
import org.apache.flex.abc.semantics.Namespace;
import org.apache.flex.abc.semantics.Nsset;
import org.apache.flex.compiler.common.DependencyType;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.INamespaceDefinition;
import org.apache.flex.compiler.definitions.references.IReference;
import org.apache.flex.compiler.internal.definitions.NamespaceDefinition;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.projects.ICompilerProject;

public class LexicalReference
implements IReference {
    private final String name;

    public LexicalReference(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Set<INamespaceDefinition> getNamespaceSet(ICompilerProject project, ASScope scope) {
        return scope.getNamespaceSetForName(project, this.getName());
    }

    @Override
    public IDefinition resolve(ICompilerProject project, ASScope scope, DependencyType depencencyType, boolean canEscapeWith) {
        return scope.findProperty(project, this.getName(), depencencyType, canEscapeWith);
    }

    @Override
    public String getDisplayString() {
        return this.name;
    }

    @Override
    public Name getMName(ICompilerProject project, ASScope scope) {
        Name n = null;
        Set<INamespaceDefinition> namespaceSet = scope.getNamespaceSetForName(project, this.name);
        ArrayList<Namespace> ns_set = new ArrayList<Namespace>(namespaceSet.size());
        for (INamespaceDefinition namespace : namespaceSet) {
            ns_set.add(((NamespaceDefinition)namespace).resolveAETNamespace(project));
        }
        n = new Name(9, new Nsset(ns_set), this.name);
        return n;
    }

    public String toString() {
        return this.getName();
    }
}

