/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.config;

import java.util.Collection;
import org.apache.flex.compiler.config.Configuration;
import org.apache.flex.compiler.config.ICompilerProblemSettings;
import org.apache.flex.compiler.problems.ICompilerProblem;

public class CompilerProblemSettings
implements ICompilerProblemSettings {
    Configuration configuration;

    public CompilerProblemSettings(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean isSourcePathOverlapAllowed() {
        return this.configuration.getAllowSourcePathOverlap();
    }

    @Override
    public boolean showActionScriptWarnings() {
        return this.configuration.warnings();
    }

    @Override
    public boolean showDeprecationWarnings() {
        return this.configuration.showDeprecationWarnings();
    }

    @Override
    public boolean isStrict() {
        return this.configuration.strict();
    }

    @Override
    public Collection<Class<ICompilerProblem>> getErrorProblems() {
        return this.configuration.getErrorProblems();
    }

    @Override
    public Collection<Class<ICompilerProblem>> getWarningProblems() {
        return this.configuration.getWarningProblems();
    }

    @Override
    public Collection<Class<ICompilerProblem>> getIgnoreProblems() {
        return this.configuration.getIgnoreProblems();
    }

    @Override
    public boolean showBindingWarnings() {
        return this.configuration.showBindingWarnings();
    }

    @Override
    public boolean showUnusedTypeSelectorWarnings() {
        return this.configuration.showUnusedTypeSelectorWarnings();
    }

    @Override
    public boolean showMultipleDefinitionWarnings() {
        return this.configuration.showMultipleDefinitionWarnings();
    }

    @Override
    public boolean checkActionScriptWarning(int warningCode) {
        boolean warning = false;
        switch (warningCode) {
            case 1044: {
                warning = this.configuration.warn_array_tostring_changes();
                break;
            }
            case 1100: {
                warning = this.configuration.warn_assignment_within_conditional();
                break;
            }
            case 1112: {
                warning = this.configuration.warn_bad_array_cast();
                break;
            }
            case 3590: {
                warning = this.configuration.warn_bad_bool_assignment();
                break;
            }
            case 3575: {
                warning = this.configuration.warn_bad_date_cast();
                break;
            }
            case 3594: {
                warning = this.configuration.warn_bad_es3_type_method();
                break;
            }
            case 3592: {
                warning = this.configuration.warn_bad_es3_type_prop();
                break;
            }
            case 1098: {
                warning = this.configuration.warn_bad_nan_comparison();
                break;
            }
            case 1102: {
                warning = this.configuration.warn_bad_null_assignment();
                break;
            }
            case 1096: {
                warning = this.configuration.warn_bad_null_comparison();
                break;
            }
            case 1012: {
                warning = this.configuration.warn_bad_undefined_comparison();
                break;
            }
            case 1034: {
                warning = this.configuration.warn_boolean_constructor_with_no_args();
                break;
            }
            case 1066: {
                warning = this.configuration.warn_changes_in_resolve();
                break;
            }
            case 1072: {
                warning = this.configuration.warn_class_is_sealed();
                break;
            }
            case 1110: {
                warning = this.configuration.warn_const_not_initialized();
                break;
            }
            case 1030: {
                warning = this.configuration.warn_constructor_returns_value();
                break;
            }
            case 1090: {
                warning = this.configuration.warn_deprecated_event_handler_error();
                break;
            }
            case 1060: {
                warning = this.configuration.warn_deprecated_function_error();
                break;
            }
            case 1058: {
                warning = this.configuration.warn_deprecated_property_error();
                break;
            }
            case 3583: {
                warning = this.configuration.warn_duplicate_argument_names();
                break;
            }
            case 3596: {
                warning = this.configuration.warn_duplicate_variable_def();
                break;
            }
            case 1086: {
                warning = this.configuration.warn_for_var_in_changes();
                break;
            }
            case 3581: {
                warning = this.configuration.warn_import_hides_class();
                break;
            }
            case 3555: {
                warning = this.configuration.warn_instance_of_changes();
                break;
            }
            case 1088: {
                warning = this.configuration.warn_internal_error();
                break;
            }
            case 1070: {
                warning = this.configuration.warn_level_not_supported();
                break;
            }
            case 1084: {
                warning = this.configuration.warn_missing_namespace_decl();
                break;
            }
            case 1092: {
                warning = this.configuration.warn_negative_uint_literal();
                break;
            }
            case 1104: {
                warning = this.configuration.warn_no_constructor();
                break;
            }
            case 1114: {
                warning = this.configuration.warn_no_explicit_super_call_in_constructor();
                break;
            }
            case 1008: {
                warning = this.configuration.warn_no_type_decl();
                break;
            }
            case 1038: {
                warning = this.configuration.warn_number_from_string_changes();
                break;
            }
            case 1082: {
                warning = this.configuration.warn_scoping_change_in_this();
                break;
            }
            case 3551: {
                warning = this.configuration.warn_slow_text_field_addition();
                break;
            }
            case 3553: {
                warning = this.configuration.warn_unlikely_function_value();
                break;
            }
            case 3573: {
                warning = this.configuration.warn_xml_class_has_changed();
            }
        }
        return warning;
    }

    @Override
    public boolean showWarnings() {
        return this.configuration.getWarnings();
    }
}

