/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.caches;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.flex.compiler.internal.caches.CacheStoreKeyBase;
import org.apache.flex.compiler.internal.caches.ConcurrentCacheStoreBase;
import org.apache.flex.compiler.internal.caches.FileScopeCache;
import org.apache.flex.compiler.internal.caches.SWFCache;
import org.apache.flex.swc.ISWC;
import org.apache.flex.swc.ISWCScript;
import org.apache.flex.swc.SWCManager;
import org.apache.flex.swf.ITagContainer;
import org.apache.flex.swf.TagType;
import org.apache.flex.swf.tags.ICharacterReferrer;
import org.apache.flex.swf.tags.ICharacterTag;
import org.apache.flex.swf.tags.ITag;
import org.apache.flex.swf.tags.SymbolClassTag;

public class AssetTagCache
extends ConcurrentCacheStoreBase<AssetTagCacheValue> {
    private final SWCManager swcManager;

    public static AssetTagCacheKey createKey(ISWC swc, String swfPath, ISWCScript script, String qname) {
        AssetTagCacheKey key = new AssetTagCacheKey();
        key.swc = swc;
        key.swfPath = swfPath;
        key.scriptName = script.getName();
        key.qname = qname;
        return key;
    }

    public AssetTagCache(SWCManager swcManager) {
        this.swcManager = swcManager;
    }

    @Override
    protected AssetTagCacheValue createEntryValue(CacheStoreKeyBase key) {
        if (!(key instanceof AssetTagCacheKey)) {
            throw new IllegalArgumentException("expect AssetTagCacheKey but got " + key.getClass().getSimpleName());
        }
        AssetTagCacheKey assetTagCacheKey = (AssetTagCacheKey)key;
        ITagContainer tagContainer = (ITagContainer)this.swcManager.getSWFCache().get(SWFCache.createKey(assetTagCacheKey.swc, assetTagCacheKey.swfPath));
        SymbolClassTag symbolClassTag = AssetTagCache.getSymbolClass(tagContainer);
        if (symbolClassTag == null) {
            return new AssetTagCacheValue(null);
        }
        ICharacterTag assetTag = symbolClassTag.getSymbol(assetTagCacheKey.qname);
        AssetTagCacheValue result = new AssetTagCacheValue(assetTag);
        AssetTagCache.getAllReferredTags(assetTag, result.referredTags);
        return result;
    }

    private static SymbolClassTag getSymbolClass(ITagContainer tagContainer) {
        for (ITag tag : tagContainer) {
            if (tag.getTagType() != TagType.SymbolClass) continue;
            return (SymbolClassTag)tag;
        }
        return null;
    }

    private static void getAllReferredTags(ITag tag, Collection<ITag> referredTags) {
        if (tag instanceof ICharacterReferrer) {
            for (ITag iTag : ((ICharacterReferrer)((Object)tag)).getReferences()) {
                assert (iTag != null);
                referredTags.add(iTag);
                AssetTagCache.getAllReferredTags(iTag, referredTags);
            }
        }
    }

    public static class AssetTagCacheValue {
        public final ICharacterTag assetTag;
        public final Collection<ITag> referredTags;

        private AssetTagCacheValue(ICharacterTag assetTag) {
            this.assetTag = assetTag;
            this.referredTags = new LinkedList<ITag>();
        }
    }

    protected static class AssetTagCacheKey
    extends FileScopeCache.FileScopeCacheKey {
        protected String qname;

        protected AssetTagCacheKey() {
        }

        @Override
        public String generateKey() {
            return String.format("%s:%s:%s:%s", this.swc.getSWCFile().getAbsolutePath(), this.swfPath, this.scriptName, this.qname).intern();
        }
    }
}

