/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.abc.semantics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.flex.abc.semantics.Name;
import org.apache.flex.abc.semantics.Trait;

public class Traits
implements Iterable<Trait> {
    private Vector<Trait> elements = new Vector();
    private Map<Name, Integer> nameToKinds = new HashMap<Name, Integer>();

    public int getTraitCount() {
        return this.elements.size();
    }

    @Override
    public Iterator<Trait> iterator() {
        return this.elements.iterator();
    }

    public boolean add(Trait t) {
        Integer i = this.nameToKinds.get(t.getName());
        int flags = i != null ? i : 0;
        this.nameToKinds.put(t.getName(), flags |= this.getBitMaskForKind(t.getKind()));
        return this.elements.add(t);
    }

    public boolean containsTrait(int kind, Name name) {
        int flags;
        Integer i = this.nameToKinds.get(name);
        return i != null && ((flags = i.intValue()) & this.getBitMaskForKind(kind)) != 0;
    }

    private final int getBitMaskForKind(int kind) {
        return 1 << kind;
    }
}

